import { useLoader } from '@/context/LoaderContext';
import { useState, useCallback } from 'react';
import { SCREEN_TYPES } from '../utils/constants';

export const useScreenManager = () => {
    const [selectedOption, setSelectedOption] = useState(null);
    const { currentScreen, setCurrentScreen } = useLoader();
    const navigateTo = useCallback((screen) => {
        setCurrentScreen(screen)
    }, []);
    const selectOption = useCallback((option) => setSelectedOption(option), []);
    const reset = useCallback(() => {
        setCurrentScreen(SCREEN_TYPES.WELCOME);
        setSelectedOption(null);
    }, []);
    const isCurrentScreen = useCallback((screen) => currentScreen === screen, [currentScreen]);
    const getCurrentScreenInfo = useCallback(() => ({
        screen: currentScreen,
        isLoading: currentScreen.includes('loading'),
        isComplete: currentScreen === SCREEN_TYPES.COMPLETE,
        isSetup: currentScreen.includes('step') || currentScreen === SCREEN_TYPES.PROJECT_SETUP
    }), [currentScreen]);

    return { selectedOption, navigateTo, selectOption, reset,     isCurrentScreen,
        getCurrentScreenInfo };
};
