import json
import requests
import sqlite3

DB_FILE = "insight.db"

def fetch_devices(router_ip):
    try:
        response = requests.get(f"http://{router_ip}/api/kommazen/devices", timeout=10)
        response.raise_for_status()
        return response.json()
    except requests.exceptions.RequestException as e:
        print(f"error fetching: {e}")
        return None

def setup_database(cursor):
    cursor.execute(f"""
    CREATE TABLE IF NOT EXISTS devices (
        id TEXT PRIMARY KEY,
        site_ip TEXT,
        name TEXT,
        type TEXT,
        password TEXT,
        mac TEXT,
        ip TEXT,
        currentAP TEXT,
        currentAP_name TEXT,
        addedBy TEXT,
        addedAt TEXT,
        firstConnectedAt TEXT,
        lastConnectedAt TEXT,
        network TEXT,
        online INTEGER,
        last_checked_at TEXT,
        auth INTEGER,
        authorized INTEGER,
        signal INTEGER,
        bytes_rx INTEGER,
        bytes_tx INTEGER,
        packets_rx INTEGER,
        packets_tx INTEGER,
        rate_rx INTEGER,
        rate_tx INTEGER
    );
    """)

# current sites: lab, estrell, arthur
# INSERT INTO sites (name, ip, network_id) VALUES ("lab", "192.168.201.21", "d944ab83-ed7a-4e60-8629-7a10fb596d84");
# INSERT INTO sites (name, ip) VALUES ("arthur", "192.168.201.26");
# INSERT INTO sites (name, ip) VALUES ("estrell", "192.168.201.35");

    cursor.execute(f"""
    CREATE TABLE IF NOT EXISTS sites (
	id	INTEGER,
	name	TEXT,
	ip TEXT,
	network_id TEXT,
	PRIMARY KEY(id)
        );
        """)

def save_to_db(devices_data, site):
    if not devices_data:
        print("is nix da")
        return

    with sqlite3.connect(DB_FILE) as conn:
        cursor = conn.cursor()
        setup_database(cursor)

        for device in devices_data:

            values = (
                device.get('id'), site, device.get('name'), device.get('type'),
                site,
                device.get('password'), device.get('mac'), device.get('ip'),
                device.get('currentAP'), device.get('currentAP_name'),
                device.get('addedBy'), device.get('addedAt'),
                device.get('firstConnectedAt'), device.get('lastConnectedAt'),
                device.get('network'), device.get('online'),
                device.get('last_checked_at'), device.get('auth'),
                device.get('authorized'), device.get('signal'),
                device.get('bytes_rx'), device.get('bytes_tx'),
                device.get('packets_rx'), device.get('packets_tx'),
                device.get('rate_rx'), device.get('rate_tx')
            )

            cursor.execute(f"""
            INSERT OR REPLACE INTO devices (
                id, site_ip, name, type, password, mac, ip, currentAP, currentAP_name,
                addedBy, addedAt, firstConnectedAt, lastConnectedAt, network,
                online, last_checked_at, auth, authorized, signal, bytes_rx,
                bytes_tx, packets_rx, packets_tx, rate_rx, rate_tx
            ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
            """, values)

        conn.commit()

def add_device(site, device_name):
    # todo: get vars from db
    site_ip = "192.168.201.21"
    site_network = "d944ab83-ed7a-4e60-8629-7a10fb596d84"
    url = f'http://{site_ip}/api/kommazen/networks/{site_network}/devices'

    payload = {
        "name": f"{device_name}",
        "type": "laptop"
    }
    try:
        response = requests.post(url, json=payload, timeout=10)
        response.raise_for_status()
        return response.json()
    except requests.exceptions.RequestException as e:
        print(f"error creating device: {e}")

def get_devices(router_ip):
    fetch_devices(router_ip=router_ip)

    with sqlite3.connect(DB_FILE) as conn:
        cursor = conn.cursor()
        setup_database(cursor)
        cursor.execute(f"SELECT id, name, password FROM devices WHERE site_ip='{router_ip}'")
        devices = cursor.fetchall()
        return devices

def get_sites():
    with sqlite3.connect(DB_FILE) as conn:
        cursor = conn.cursor()
        setup_database(cursor)
        cursor.execute("SELECT ip, id, name FROM sites")
        sites = cursor.fetchall()
        return sites

if __name__ == "__main__":
    sites = get_sites()

    for site in sites:

        device_list = fetch_devices(site[0])
        if device_list:
            save_to_db(device_list, site[0])

    print(add_device(1, "uwubullu2sais3so"))
    print(get_devices("192.168.201.21"))
