from flask import Flask
from flask_httpauth import HTTPBasicAuth
import json
import helferlein

app = Flask(__name__)
auth = HTTPBasicAuth()

@auth.verify_password
def authenticate(user, apikey):
    key = apikey
    if key == "uniberg":
        return True
    else:
        return False

@app.route("/sites")
@auth.login_required
def sites():
    sites = helferlein.get_sites()
    return json.dumps(sites)

@app.route("/devices")
@auth.login_required
def devices():
    devices = helferlein.get_devices("192.168.201.21")
    return json.dumps(devices)
