# Monitoring

# GaLiGrü

### tldr

the monitoring stack consists of rsyslog running directly on the kommazen🪺 and some containers composed with docker-compose. the kommazen🪺 stores metrics, logs and also runs a grafana instance to visualize the data.

---

### links

- **repository:** [**https://git.uniberg.com/ub-edge/kommandozentrale/-/tree/main/monitoring**](https://git.uniberg.com/ub-edge/kommandozentrale/-/tree/main/monitoring)
- **docker-compose:** [**https://git.uniberg.com/ub-edge/kommandozentrale/-/blob/main/monitoring/docker-compose.yml**](https://git.uniberg.com/ub-edge/kommandozentrale/-/blob/main/monitoring/docker-compose.yml)

---

### components

- rsyslog
- prometheus
- node-exporter
- grafana
- loki

# Logging

![](/api/files/01990f6b-84e1-707b-be6e-ec6abf20b8e0/logfiles.drawio.png)

## rsyslog

rsyslog recives remote system logs. 🪿quak

the logs written to the teltonika are also being sent to rsyslog running on the kommazen🪺 via port 514 udp and then stored as plaintext files under `<repo>/monitoring/logs/<macOfTeltonika>/<application>.log`

```
# add tree output here
echo uwu
```

### rsyslog.conf

the only thing worth mentioning is `$UDPServerAddress 192.168.201.96` so that it’s bound to the wireguard interface

```
# /etc/rsyslog.conf configuration file for rsyslog
#
# For more information install rsyslog-doc and see
# /usr/share/doc/rsyslog-doc/html/configuration/index.html


#################
#### MODULES ####
#################

module(load="imuxsock") # provides support for local system logging
module(load="imklog")   # provides kernel logging support
#module(load="immark")  # provides --MARK-- message capability

# provides UDP syslog reception
module(load="imudp")
input(type="imudp" port="514")
$UDPServerAddress 192.168.201.96

# provides TCP syslog reception
module(load="imtcp")
input(type="imtcp" port="514")
$TCPServerAddress 192.168.201.96

###########################
#### GLOBAL DIRECTIVES ####
###########################

#
# Set the default permissions for all log files.
#$UDPServerAddress 192.168.201.96
$FileOwner grafana
$FileGroup grafana
$FileCreateMode 0755
$DirCreateMode 0755
$Umask 0022

#
# Where to place spool and state files
#
$WorkDirectory /var/spool/rsyslog

#
# Include all config files in /etc/rsyslog.d/
#
$IncludeConfig /etc/rsyslog.d/*.conf


###############
#### RULES ####
###############

#
# Log anything besides private authentication messages to a single log file
#
#*.*;auth,authpriv.none         -/var/log/syslog

#
# Log commonly used facilities to their own log file
#
#auth,authpriv.*                        /var/log/auth.log
#cron.*                         -/var/log/cron.log
#kern.*                         -/var/log/kern.log
#mail.*                         -/var/log/mail.log
#user.*                         -/var/log/user.log

#
# Emergencies are sent to everybody logged in.
#
#*.emerg                                :omusrmsg:*
```

### /etc/rsyslog.d/rsyslog_ubedge.conf

this config says how to store the recieved logs, this is why the log files are stored where they are stored.

```
$template RemoteLogs,"/root/monitoring/logs/%HOSTNAME%/%PROGRAMNAME%.log"
*.* ?RemoteLogs
& ~
```

### teltonika config

the following config has to be set so that the teltonika also writes logs to the kommazen🪺

```
# /etc/config/system
config system
[...]
   option log_ip 192.168.201.96
   option log_port 514
   option log_proto udp
[...]
```

don’t forget the firewall

```
config rule
      option target 'ACCEPT'
      option dest 'wg0'
      option proto 'udp'
      option dest_port '514'
      option name 'ISSO-LOGS'
```

### use cases for debugging

you can just `grep` through the log files on the filesystem - or download them to your computer. the possibilites are endless, isso.

## promtail

promtail is used to push the logs from the local filesystem to loki

### example config

```
server:
  http_listen_port: 9080
  grpc_listen_port: 0

positions:
  filename: /tmp/positions.yaml

clients:
  - url: http://loki:3100/loki/api/v1/push

scrape_configs:
  - job_name: zentrale
    static_configs:
      - targets:
          - localhost
        labels:
          job: system
          __path__: /var/log/*log

  - job_name: ub_edge
    static_configs:
      - targets:
          - localhost
        labels:
          job: device
          __path__: /mnt/*/*.log
```

## loki

loki aggregates the logs and is then integrated into grafana

### example config

```
# This is a complete configuration to deploy Loki backed by the filesystem.
# The index will be shipped to the storage via tsdb-shipper.

auth_enabled: false

server:
  http_listen_port: 3100

common:
  ring:
    instance_addr: 127.0.0.1
    kvstore:
      store: inmemory
  replication_factor: 1
  path_prefix: /tmp/loki

schema_config:
  configs:
    - from: 2020-05-15
      store: tsdb
      object_store: filesystem
      schema: v13


      index:
        prefix: index_
        period: 24h

storage_config:
  filesystem:
    directory: /tmp/loki/chunks
```

### use cases for debugging

isso

# Metrics

## node-exporter

## prometheus

# Alerting

# Visualization

## Grafana

# Setup

## variables to check out

## install rsyslog

## run docker-compose

# Monitoring


https://projects.uniberg.com/issues/3495

[prometheus](http://192.168.201.96:9090)


[Grafana](http://192.168.201.96:3000/d/fLi0yXAWk/ub-edge?orgId=1&from=now-1h&to=now&timezone=browser&var-job=arthur_teltonika&var-site=arthur&refresh=10s)

creds:

admin
Uwuberg1337!


## ToDo

- security
- rewrite qmpi exporter in lua
- write batman exporter
- get access point data - finish integration
- filter metrics


## manual changes on my teltonika


```sh

1. changed etc hosts

root@209727539a1f:~# cat /etc/hosts
127.0.0.1 localhost
fd42:dead:c0de:1337:0:f44d:5cfe:7642 ap1
fd42:dead:c0de:1337:0:f44d:5cfe:7627 ap2


2. added redirects to the nginx conf
root@209727539a1f:~# cat /etc/nginx/nginx.conf

[...]
        location /metrics/ap1 {
                proxy_pass http://ap1:9100/metrics
        }

        location /metrics/ap2 {
                proxy_pass http://ap2:9100/metrics
        }

        location /metrics/ap3 {
                proxy_pass http://ap3:9100/metrics
        }

        location /metrics/ap4 {
                proxy_pass http://ap4:9100/metrics
        }
[...]

3. changed prometheus config on all access points and restarted it

root@f44d5cfe7627:~# cat /etc/config/prometheus-node-exporter-lua
config prometheus-node-exporter-lua 'main'
        option listen_interface '*'
        option listen_port '9100'


4. disabled firewall on access points. better would be if there was a rule in place

root@209727539a1f:~# ssh ap2
root@f44d5cfe7627:~# /etc/init.d/firewall stop


```
