#!/bin/sh

set -xe

TARGET="ipq40xx"
SUBTARGET="generic"
SDK_NAME="openwrt-sdk-24.10-SNAPSHOT-$TARGET-${SUBTARGET}_gcc-13.3.0_musl_eabi.Linux-x86_64"
SDK_ARCHIVE="$SDK_NAME.tar.zst"

SDK_DOWNLOAD_URL="https://mirror-03.infra.openwrt.org/releases/24.10-SNAPSHOT/targets/$TARGET/$SUBTARGET/$SDK_ARCHIVE"

WORK_DIR="$1"
REPO_DIR="$2"
PKG_OUTPUT_DIR="$3"
PKG_NAME="uniberg-uconfigd-controller"

# Download SDK
wget -O "$WORK_DIR/$SDK_ARCHIVE" "$SDK_DOWNLOAD_URL"

# Extract SDK
tar -C "$WORK_DIR" -xf "$WORK_DIR/$SDK_ARCHIVE"

# Enter SDK directory
cd "$WORK_DIR/$SDK_NAME"

# Prepare feeds.conf
cp feeds.conf.default feeds.conf
echo "src-link custom $REPO_DIR" >> feeds.conf

# Update feeds
./scripts/feeds update -a
./scripts/feeds install -a

# Compile package
make defconfig
make package/$PKG_NAME/compile V=s -j6

# Copy packages to package directory
mv bin/packages/* "$PKG_OUTPUT_DIR"
