#!/bin/sh -e

export CGO_ENABLED=0 
BIN=uconfigd-controller
for bla in 'GOOS=linux GOARCH=arm64' 'GOOS=linux GOARCH=amd64' 'GOOS=darwin GOARCH=arm64' 'GOOS=linux GOARCH=arm GOARM=7'
do
	export $bla
	touch err_${GOOS}_${GOARCH}
	( go build -o ${BIN}.${GOOS}.${GOARCH} > ${GOOS}_${GOARCH}_stdout.log 2>${GOOS}_${GOARCH}_stderr.log &&
		rm err_${GOOS}_${GOARCH}
	) &
done
wait
for failed in `ls err_* 2>/dev/null ||true`
do
	s=$(echo $failed | sed 's/err_//')
	echo failed golang build: $s
	cat ${s}_stdout.log ${s}_stderr.log
done
ls err_* 2>/dev/null && exit 1
echo go builds successful:
ls -lh ${BIN}.*
exit 0
