package announcement

import (
	"net"
	"strconv"
	"time"
	"uniberg/uconfigd-controller/services/config"

	"golang.org/x/net/ipv6"
)

type AnnouncementData struct {
	ConfigRev   int64
	BroadcastIf string
}

var AD AnnouncementData

func UpdateAnnouncementData() {
	netconf, _ := config.GetConfig()
	AD.ConfigRev = netconf.UUID
}

func AnnouncementFunction() {
	groupString := "ff02::114"
	port := 59176

	c, err := net.ListenPacket("udp6", "[::]:"+strconv.Itoa(port))
	if err != nil {
		/* Error handling */
	}

	group := net.ParseIP(groupString)
	dst := &net.UDPAddr{IP: group, Port: port}
	for {
		iface, err := net.InterfaceByName(AD.BroadcastIf)
		if err != nil {
			continue
		}

		wcm := ipv6.ControlMessage{TrafficClass: 0xe0, HopLimit: 1}
		wcm.IfIndex = iface.Index

		p := ipv6.NewPacketConn(c)
		if err := p.JoinGroup(iface, &net.UDPAddr{IP: group}); err != nil {
			continue
		}

		message := []byte(strconv.Itoa(int(AD.ConfigRev)))

		if _, err := p.WriteTo(message, &wcm, dst); err != nil {
			continue
		}

		time.Sleep(5 * time.Second)
	}
}
