package config

type DeviceConfigSSH struct {
	AuthorizedKeys []string `json:"authorized-keys"`
	PasswordAuth   bool     `json:"password-authentication"`
}

type DeviceConfigServices struct {
	SSH DeviceConfigSSH `json:"ssh"`
}

type DeviceConfigUnit struct {
	Name     string `json:"name"`
	Location string `json:"location"`
	Timezone string `json:"timezone"`
}

type DeviceConfigTunnel struct {
	Protocol string `json:"proto"`
	Wired    bool   `json:"wired"`
}

type DeviceConfigSSIDEncryption struct {
	Proto string `json:"proto"`
	Key   string `json:"key,omitempty"`
}

type DeviceConfigSSIDMultiPSK struct {
	Mac    string `json:"mac"`
	VlanId int    `json:"vlan-id,omitempty"`
	Key    string `json:"key"`
}

type DeviceConfigSSID struct {
	SSID       string                     `json:"ssid"`
	WiFiRadios []string                   `json:"wifi-radios"`
	BSSMode    string                     `json:"bss-mode"`
	Encryption DeviceConfigSSIDEncryption `json:"encryption"`
	MultiPSK   []DeviceConfigSSIDMultiPSK `json:"multi-psk,omitempty"`
}

type DeviceConfigIPv4 struct {
	Addressing string                 `json:"addressing"`
	Subnet     string                 `json:"subnet,omitempty"`
	DHCP       map[string]interface{} `json:"dhcp,omitempty"` // Note the omitempty tag
}

type DeviceConfigVlan struct {
	Id int `json:"id"`
}

type DeviceConfigInterface struct {
	Role     string                      `json:"role"`
	Services []string                    `json:"services,omitempty"`
	Ports    map[string]string           `json:"ports"`
	IPv4     *DeviceConfigIPv4           `json:"ipv4,omitempty"`
	IPv6     *map[string]string          `json:"ipv6,omitempty"`
	SSIDs    map[string]DeviceConfigSSID `json:"ssids,omitempty"`
	Tunnel   *DeviceConfigTunnel         `json:"tunnel,omitempty"`
	Vlan     *DeviceConfigVlan           `json:"vlan,omitempty"`
	Mtu      int                         `json:"mtu,omitempty"`
}

type DeviceConfigRadio struct {
	Channel      int    `json:"channel"`
}

type DeviceConfig struct {
	UUID        int64                `json:"uuid"`
	Unit        DeviceConfigUnit     `json:"unit"`
	Services    DeviceConfigServices `json:"services"`
	CountryCode string               `json:"country_code"`
	Password    bool                 `json:"password"`

	Radios     map[string]DeviceConfigRadio     `json:"radios"`
	Interfaces map[string]DeviceConfigInterface `json:"interfaces"`
}
