package database

import (
	"github.com/glebarez/sqlite"
	"gorm.io/gorm"
)

type WirelessRadio struct {
	gorm.Model

	Band       int
	DeviceID   uint
}

type Device struct {
	gorm.Model

	DeviceName string
	MacAddress string
	IpAddress  string

	EncryptionKey string

	ModelType string
	ModelName string
	Role      string

	SetupWiFiSSID string
	SetupWiFiKey  string

	Radios []WirelessRadio `gorm:"foreignKey:DeviceID;references:ID"`
}

type Password struct {
	gorm.Model

	MacAddress string
	NetworkId  string `gorm:"uniqueIndex:net_pass_uniq"`
	Password   string `gorm:"uniqueIndex:net_pass_uniq"`
}

var DB *gorm.DB

func GetDB(db_path string) *gorm.DB {
	db, err := gorm.Open(sqlite.Open(db_path), &gorm.Config{})
	if err != nil {
		panic("failed to connect database")
	}

	// Migrate the schema
	db.AutoMigrate(&Device{})

	DB = db
	return db
}

func CloseDB() {
	sqlDB, err := DB.DB()
	if err != nil {
		panic("failed to close database")
	}
	sqlDB.Close()
}
