package devices

import (
	"uniberg/uconfigd-controller/services/database"
)

type AccessPointRadio struct {
	Band      string `json:"band"`
}

type AccessPoint struct {
	Name      string             `json:"name"`
	Serial    string             `json:"serial"`
	Mac       string             `json:"mac"`
	IpAddress string             `json:"ip_address"`
	Radios    []AccessPointRadio `json:"radios"`
}

func ConvertBandToString(band int) string {
	switch band {
	case 2:
		return "BAND_2G"
	case 5:
		return "BAND_5G"
	default:
		return "Unknown"
	}
}

func GetDevices() []AccessPoint {
	// Read Devices from Database
	var devices []database.Device
	database.DB.Preload("Radios").Find(&devices)
	accessPoints := []AccessPoint{}
	for _, ap := range devices {
		radios := []AccessPointRadio{}
		for _, radio := range ap.Radios {

			r := AccessPointRadio{
				Band:      ConvertBandToString(radio.Band),
			}
			radios = append(radios, r)
		}
		accessPoint := AccessPoint{
			Name:      ap.DeviceName,
			Serial:    ap.MacAddress,
			Mac:       ap.MacAddress,
			IpAddress: ap.IpAddress,
			Radios:    radios,
		}
		accessPoints = append(accessPoints, accessPoint)
	}
	return accessPoints
}
