package handlers

import (
	"edge-api/internal/database"
	"edge-api/internal/models"
	"edge-api/internal/services"
	"log"
	"net/http"
	"strings"

	"github.com/gin-gonic/gin"
)

func APList(c *gin.Context) {
	aps := []models.AP{}

	err := database.DB.Select(&aps, "SELECT * FROM aps ORDER BY name ASC")
	if err != nil {
		log.Printf("ERROR: Failed to fetch aps from database: %v\n", err)
		c.JSON(http.StatusInternalServerError, gin.H{"error": "Failed to fetch access points"})
		return
	}
	// i need this to create the mac address, we don't save it currently
	const namePrefix = "ap-"

	for i := range aps {
		currentAP := aps[i]
		currentAP.Mac = strings.TrimPrefix(currentAP.Name, namePrefix)
		currentAP = services.CheckAPOnlineStatus(currentAP)

		var deviceCountErr error

		currentAP, deviceCountErr = services.GetConnectedDevicesPerAP(currentAP, database.DB)

		if deviceCountErr != nil {
			log.Printf("Failed to get device count for AP %s (%s): %v\n", currentAP.ID, currentAP.Name, deviceCountErr)

		}
		aps[i] = currentAP
	}

	c.JSON(http.StatusOK, aps)
}

func APDetails(c *gin.Context) {
	id := c.Param("ap_id")

	var ap models.AP

	err := database.DB.Get(&ap, "SELECT * FROM aps WHERE id=?", id)
	if err != nil {
		c.JSON(http.StatusNotFound, gin.H{"error": "AP not found"})
		return
	}

	c.JSON(http.StatusOK, ap)
}
