package middlewares

import (
	"edge-api/internal/models"
	"net/http"
	"os"

	"github.com/dgrijalva/jwt-go"
	"github.com/gin-gonic/gin"
)

func Auth(secret string) gin.HandlerFunc {

	isDev := os.Getenv("APP_ENV") == "development"
	if isDev {
		return func(c *gin.Context) {
			c.Set("username", "admin")
			c.Next()
		}
	}

	return func(c *gin.Context) {
		cookie, err := c.Request.Cookie("apiKey") // Get from cookie
		if err != nil {
			if err == http.ErrNoCookie {
				c.AbortWithStatusJSON(http.StatusUnauthorized, gin.H{"error": "API key is required"})
				return
			}
			c.AbortWithStatusJSON(http.StatusBadRequest, gin.H{"error": "Bad Request"}) // Handle other cookie errors
			return
		}

		tokenStr := cookie.Value
		claims := &models.Claims{}
		token, err := jwt.ParseWithClaims(tokenStr, claims, func(token *jwt.Token) (interface{}, error) {
			return []byte(secret), nil
		})

		if err != nil || !token.Valid {
			c.JSON(http.StatusUnauthorized, gin.H{"error": "Invalid API key"})
			c.Abort()
			return
		}

		c.Set("username", claims.UserName)
		c.Next()
	}
}
