package models

import "github.com/google/uuid"

const UserSchema = `
CREATE TABLE IF NOT EXISTS users (
    id TEXT PRIMARY KEY,
    username TEXT UNIQUE NOT NULL,
    passwordHash TEXT
);
`

type User struct {
	ID           uuid.UUID `db:"id" json:"id"`
	UserName        string    `db:"username" json:"username"`
	PasswordHash string    `db:"passwordHash" json:"-"`
}
