package repositories

import (
	"edge-api/internal/database"

	"github.com/google/uuid"
)

func InitDB(address string, adminPassHash string) {
	// Schema execution moved to main.go
	// Admin user creation
	database.DB.MustExec("DELETE FROM users WHERE username = ?", "admin")
	database.DB.MustExec(
		"INSERT INTO users (id, username, passwordHash) VALUES ($1, $2, $3)",
		uuid.New(), "admin", adminPassHash,
	)
}
