"use client"

import React from "react";
import { useAuthContext } from "@/features/auth";
import Loader from "@/app/components/Loader";

export default function AuthCheck({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {

  const { isAuthenticated } = useAuthContext();

  return isAuthenticated ? <>{children}</> : <Loader />;

}
