import React from 'react';
import {
  EuiPanel,
  EuiTitle,
  EuiSpacer,
} from '@elastic/eui';
import { FileUploadComponent } from '@/features/project-setup/components/forms/FileUploadComponent';
import getDict from '@/lib/dict';

const dict = getDict("de");

interface FileUploaderProps {
  apiLoading: boolean;
  onFileUpload: (file: File | null) => void;
  configSetup?: boolean;
}

export const FileUploader: React.FC<FileUploaderProps> = ({
  apiLoading,
  onFileUpload,
  configSetup
}) => {
  return (
    <EuiPanel>
      {!configSetup ?? <EuiTitle size="m">
        <h2>{dict.uploadText + dict.map} </h2>
      </EuiTitle>}
      <FileUploadComponent onFileSelect={onFileUpload} accept={'.pdf'} apiLoading={apiLoading}/>
      <EuiSpacer size="m" />

    </EuiPanel>
  );
};
