"use client"

// React Dependencies
import React from 'react';
// External Libraries Dependencies
import {
  EuiFlexItem, EuiFilterButton, EuiFilterGroup, EuiButtonEmpty,
  EuiFlexGroup, EuiFieldText, EuiSelect, EuiSelectOption
} from '@elastic/eui';
// Own Dependencies
import getDict from "@/lib/dict";
const dict = getDict("de");

interface FiltersProps {
  searchText: string;
  setSearchText: (value: string) => void;
  selectedType: string;
  setSelectedType: (value: string) => void;
  onlineFilter: boolean | null;
  setOnlineFilter: (value: boolean | null) => void;
  typeOptions: EuiSelectOption[];
  showOnline: boolean;
}
const Filters: React.FC<FiltersProps> = ({ searchText, setSearchText, selectedType, setSelectedType, onlineFilter, setOnlineFilter, typeOptions, showOnline }) => {
  const handleResetFilters = () => {
    setSearchText("");
    setSelectedType("");
    setOnlineFilter(null);
  };
  return (
    <EuiFlexGroup gutterSize="m" alignItems="center" responsive={false}>
      <EuiFlexItem grow={2}>
        <EuiFieldText
          placeholder={dict.search}
          value={searchText}
          onChange={(e) => setSearchText(e.target.value)}
          fullWidth
        />
      </EuiFlexItem>

      <EuiFlexItem grow={1}>
        <EuiSelect
          prepend={dict.type}
          options={[
            {
              value: '',
              text: dict.selectDeviceType,
              disabled: true
            },
            ...typeOptions,
          ]}
          value={selectedType}
          onChange={(e) => setSelectedType(e.target.value)}
          aria-label="Filter by type"
          fullWidth
        />
      </EuiFlexItem>

      {showOnline ? <EuiFlexItem grow={1}>
        <EuiFilterGroup>
          <EuiFilterButton
            hasActiveFilters={onlineFilter === true}
            onClick={() => setOnlineFilter(onlineFilter === true ? null : true)}
          >
            {dict.online}
          </EuiFilterButton>
          <EuiFilterButton
            hasActiveFilters={onlineFilter === false}
            onClick={() => setOnlineFilter(onlineFilter === false ? null : false)}
          >
            {dict.offline}
          </EuiFilterButton>
        </EuiFilterGroup>
      </EuiFlexItem>: undefined}
      <EuiFlexItem>
        <EuiButtonEmpty
          iconType="refresh"
          size="s"
          onClick={handleResetFilters}
          color="text"
        >Reset</EuiButtonEmpty>
      </EuiFlexItem>
    </EuiFlexGroup>
  );
};

export default Filters;
