"use client";
// React Dependencies
import React, { createContext, useContext, useState, ReactNode, useCallback } from "react";
// External Libraries Dependencies
import { EuiGlobalToastList } from "@elastic/eui";

interface Toast {
  id: string;
  title: string;
  color?: "success" | "warning" | "danger" | "primary";
  text?: string;
}

interface ToastContextProps {
  addToast: (toast: Omit<Toast, "id">) => void;
}

const ToastContext = createContext<ToastContextProps | undefined>(undefined);

export const ToastProvider = ({ children }: { children: ReactNode }) => {
  const [toasts, setToasts] = useState<Toast[]>([]);
  const addToast = useCallback((toast: Omit<Toast, "id">) => {
    setToasts([]);
    setToasts((prevToasts) => [...prevToasts, { id: 'id-' + Date.now() + '-' + Math.floor(Math.random() * 10000), ...toast }]);
  }, []);

  const removeToast = useCallback((id: string) => {
    setToasts((prevToasts) => prevToasts.filter((toast) => toast.id !== id));
  }, []);

  return (
    <ToastContext.Provider value={{ addToast }}>
      {children}
      <EuiGlobalToastList
        toasts={toasts}
        dismissToast={(toast) => removeToast(toast.id)}
        toastLifeTimeMs={5000}
      />
    </ToastContext.Provider>
  );
};

export const useToast = () => {
  const context = useContext(ToastContext);
  if (!context) {
    throw new Error("useToast must be used within a ToastProvider");
  }
  return context;
};
