// React Dependencies
import React from "react";
// External Libraries Dependencies
import { EuiIcon } from "@elastic/eui";
import { bytesToMB } from "@/shared/utils";

export const TrafficConversion = (item: number | undefined, type: string) => {
  if (item !== undefined) {
    const convertKbToMg = bytesToMB(item);
    return <>{(convertKbToMg).toFixed(1)} {type}</>;
  }
  return '-';
}
