// Type definitions for ZoomPanRotation components

export interface ViewportState {
  zoomLevel: number;
  panOffset: { x: number; y: number };
  rotation: number;
  isPanning: boolean;
  lastPanPosition: { x: number; y: number };
}

export interface TouchState {
  initialDistance: number | null;
  initialZoom: number;
  isPinching: boolean;
  touchCount: number;
}

export interface ImageDimensions {
  width: number;
  height: number;
}

export interface ZoomPanState {
  viewport: ViewportState;
  pdfFile: File | null;
  accessPoints: unknown[];
  imageDimensions: ImageDimensions;
  draggedItem: unknown | null;
  touch: TouchState;
  ui: {
    showControls: boolean;
  };
}

export type ViewportAction =
  | { type: 'SET_ZOOM'; payload: number }
  | { type: 'ZOOM_IN' }
  | { type: 'ZOOM_OUT' }
  | { type: 'SET_PAN'; payload: { x: number; y: number } }
  | { type: 'START_PAN'; payload: { x: number; y: number } }
  | { type: 'UPDATE_PAN'; payload: { x: number; y: number } }
  | { type: 'END_PAN' }
  | { type: 'SET_ROTATION'; payload: number }
  | { type: 'ROTATE_LEFT' }
  | { type: 'ROTATE_RIGHT' }
  | { type: 'RESET_VIEW' }
  | { type: 'FIT_TO_VIEW'; payload: { containerWidth: number; containerHeight: number } }
  | { type: 'SET_DRAGGED_ITEM'; payload: unknown | null }
  | { type: 'SET_PDF_FILE'; payload: File | null }
  | { type: 'SET_IMAGE_DIMENSIONS'; payload: ImageDimensions }
  | { type: 'SET_TOUCH'; payload: Partial<TouchState> }
  | { type: 'CROP_TO_VIEWPORT'; payload: { newDimensions: ImageDimensions } }
  | { type: 'UPDATE_AFTER_CROP'; payload: { imageDimensions: ImageDimensions } };

export interface CropResult {
  dataUrl: string;
  newDimensions: ImageDimensions;
}

export interface TourStep {
  title: string;
  content: string;
}

export interface ViewportControlsProps {
  state: ZoomPanState;
  dispatch: React.Dispatch<ViewportAction>;
  containerRef: React.RefObject<HTMLDivElement>;
  onCropToViewport: () => void;
  isCropping: boolean;
}

export interface ZoomPanRotationEditorProps {
  imgsrc: string;
  navigateTo: (screen: string) => void;
  dd: (action: { type: string; payload?: unknown }) => void;
  setPdfFile: (file: File | null) => void;
}
