"use client";

import Link from "next/link";
import { getFirstPathElement, MenuItem } from "./Navigation";
import { usePathname } from "next/navigation";
import Icon from "@/app/components/Icon";
import {
  EuiSideNav,
  EuiText,
  useEuiTheme,
  EuiFlexGroup,
  EuiFlexItem,
} from "@elastic/eui";
import React from "react";

export default function Sidebar(props: { menuItems: MenuItem[] }) {
  const pathName = usePathname();
  const { euiTheme } = useEuiTheme();

  // Convert menu items to EuiSideNav format
  const sideNavItems = props.menuItems.map((item) => {
    const isActive = getFirstPathElement(pathName) === getFirstPathElement(item.href);

    return {
      id: item.href,
      name: (
        <Link
          href={item.href}
          style={{
            textDecoration: 'none',
            display: 'flex',
            alignItems: 'center',
            gap: '12px',
            width: '100%',
          }}
        >
          <EuiFlexGroup alignItems="center" gutterSize="m" responsive={false}>
            <EuiFlexItem grow={false}>
              <Icon
                name={item.icon.name}
                size="1.25rem"
                color={isActive ? euiTheme.colors.primary : euiTheme.colors.subduedText}
              />
            </EuiFlexItem>
            <EuiFlexItem>
              <EuiText
                size="m"
                style={{
                  color: isActive ? euiTheme.colors.primary : euiTheme.colors.text,
                  fontWeight: isActive ? 600 : 400,
                  textTransform: 'capitalize',
                }}
              >
                {item.text}
              </EuiText>
            </EuiFlexItem>
          </EuiFlexGroup>
        </Link>
      ),
      onClick: () => {}, // Handled by Link
      isSelected: isActive,
      forceOpen: true,
    };
  });

  return (
    <div
      style={{
        width: '280px',
        background: euiTheme.colors.lightestShade,
        borderRight: `1px solid ${euiTheme.colors.lightShade}`,
        overflowY: 'auto',
        height: '100%',
      }}
      className="sidebar-container"
    >
      <div style={{ padding: euiTheme.size.m }}>
        <EuiSideNav
          aria-label="Navigation menu"
          items={[
            {
              id: 'main-nav',
              name: '',
              items: sideNavItems,
            },
          ]}
        />
      </div>

      <style jsx global>{`
        @media (max-width: 800px) {
          .sidebar-container {
            display: none;
          }
        }

        .euiSideNavItem {
          margin-bottom: 4px;
        }

        .euiSideNavItemButton {
          border-radius: ${euiTheme.border.radius.medium};
          padding: 12px 16px;
          transition: all 0.2s ease;
        }

        .euiSideNavItemButton:hover {
          background: ${euiTheme.colors.lightShade};
        }

        .euiSideNavItemButton-isSelected {
          background: ${euiTheme.colors.lightestShade} !important;
          border-left: 3px solid ${euiTheme.colors.primary};
          padding-left: 13px;
        }

        .euiSideNavItemButton-isSelected:hover {
          background: ${euiTheme.colors.lightShade} !important;
        }
      `}</style>
    </div>
  );
}
