import React from 'react';
import { EuiFlexGroup, EuiFlexItem, EuiTitle, EuiButton } from '@elastic/eui';
import { ProjectControlsProps } from './types';
import { NodeMovementToggle } from '@/features/project-setup/components/ui';
import getDict from '@/lib/dict';

const dict = getDict("de");

export const ProjectControls: React.FC<ProjectControlsProps> = ({
  projectName,
  projectFound,
  projectUpdated,
  allowNodeMovement,
  onSave,
  onToggleNodeMovement
}) => {
  return (
    <EuiFlexGroup alignItems="center" justifyContent="spaceBetween">
      <EuiFlexItem grow={false}>
        <EuiTitle size="m">
          <h3>{projectFound ? projectName : ''} {projectUpdated ? '*' : ''}</h3>
        </EuiTitle>
      </EuiFlexItem>

      {/* Node Movement Toggle */}
      <NodeMovementToggle
        allowNodeMovement={allowNodeMovement}
        setAllowNodeMovement={onToggleNodeMovement}
      />

      {/* Save Button */}
      <EuiFlexItem grow={false}>
        {allowNodeMovement && projectFound && projectUpdated && (
          <EuiButton
            color={'success'}
            onClick={onSave}
            disabled={!allowNodeMovement}
          >
            {dict.saveProject}
          </EuiButton>
        )}
      </EuiFlexItem>
    </EuiFlexGroup>
  );
};
