import React from 'react';
import {
  EuiOverlayMask,
  EuiModal,
  EuiModalHeader,
  EuiModalHeaderTitle,
  EuiModalBody,
  EuiModalFooter,
  EuiButton,
  EuiFormRow,
  EuiFieldText,
  EuiSpacer
} from '@elastic/eui';
import getDict from '@/lib/dict';
import { useFocusTrap } from '@/shared/hooks';
import type { PDFFile } from '@/types';

const dict = getDict("de");

interface SaveProjectModalProps {
  isOpen: boolean;
  projectName: string;
  apiLoading: boolean;
  pdfFile: PDFFile | null;
  onClose: () => void;
  onSave: () => void;
  onProjectNameChange: (name: string) => void;
}

export const SaveProjectModal: React.FC<SaveProjectModalProps> = ({
  isOpen,
  projectName,
  apiLoading,
  pdfFile,
  onClose,
  onSave,
  onProjectNameChange
}) => {
  const modalRef = useFocusTrap(isOpen);

  if (!isOpen) return null;

  const handleKeyDown = (e: React.KeyboardEvent) => {
    if (e.key === 'Enter') {
      onSave();
    }
  };

  return (
    <EuiOverlayMask>
      <EuiModal onClose={onClose} maxWidth={400} ref={modalRef as any}>
        <EuiModalHeader>
          <EuiModalHeaderTitle>{dict.saveProject}</EuiModalHeaderTitle>
        </EuiModalHeader>

        <EuiModalBody>
          <EuiFormRow label={dict.name} helpText={dict.projectNameText}>
            <EuiFieldText
              value={projectName}
              onChange={(e) => onProjectNameChange(e.target.value)}
              placeholder="My Network Map"
              onKeyDown={handleKeyDown}
            />
          </EuiFormRow>

          <EuiSpacer size="m" />
        </EuiModalBody>

        <EuiModalFooter>
          <EuiButton color={"danger"} onClick={onClose}>
            {dict.cancelBtn}
          </EuiButton>
          <EuiButton
            onClick={onSave}
            color={"success"}
            disabled={!projectName.trim() || !pdfFile}
            isLoading={apiLoading}
          >
            {apiLoading ? dict.saving + '...' : dict.saveProject}
          </EuiButton>
        </EuiModalFooter>
      </EuiModal>
    </EuiOverlayMask>
  );
};