/**
 * MapCanvas Style Constants
 * Centralized styling constants for MapCanvas component
 */

import { CSSProperties } from 'react';

// Control Panel Styles
export const CONTROL_PANEL_STYLES = {
  CONTAINER: {
    position: 'absolute' as const,
    display: 'flex',
    flexDirection: 'column' as const,
  },
  BASE_CONTROL: {
    display: 'flex',
    backgroundColor: 'white',
    borderRadius: '6px',
    boxShadow: '0 2px 8px rgba(0,0,0,0.15)',
    overflow: 'hidden',
    border: '1px solid #e1e5e9',
  },
} as const;

// Button Styles
export const BUTTON_STYLES = {
  BASE: {
    border: 'none',
    backgroundColor: 'white',
    fontSize: '16px',
    fontWeight: 'bold' as const,
  },
  ZOOM: {
    padding: '8px 12px',
  },
  ROTATION: {
    padding: '8px 12px',
    fontSize: '16px',
  },
} as const;

// Display Styles
export const DISPLAY_STYLES = {
  ZOOM_PERCENTAGE: {
    padding: '8px 16px',
    backgroundColor: '#f8f9fa',
    display: 'flex',
    alignItems: 'center',
    fontSize: '13px',
    fontWeight: '500' as const,
    minWidth: '60px',
    justifyContent: 'center',
    borderLeft: '1px solid #e1e5e9',
    borderRight: '1px solid #e1e5e9',
  },
  ROTATION_DEGREES: {
    padding: '8px 12px',
    backgroundColor: '#f8f9fa',
    display: 'flex',
    alignItems: 'center',
    fontSize: '12px',
    fontWeight: '500' as const,
    minWidth: '45px',
    justifyContent: 'center',
    borderLeft: '1px solid #e1e5e9',
    borderRight: '1px solid #e1e5e9',
  },
} as const;

// Touch Drag Preview Styles
export const TOUCH_DRAG_STYLES = {
  CONTAINER: {
    position: 'fixed' as const,
    transform: 'translate(-50%, -50%)',
    pointerEvents: 'none' as const,
    zIndex: 1000,
    opacity: 0.8,
  },
  MARKER: {
    width: '24px',
    height: '24px',
    borderRadius: '50%',
    border: '2px solid white',
    display: 'flex',
    alignItems: 'center',
    justifyContent: 'center',
    color: 'white',
    fontSize: '14px',
    fontWeight: 'bold' as const,
    boxShadow: '0 4px 12px rgba(0,0,0,0.4), 0 2px 4px rgba(0,0,0,0.2)',
  },
  LABEL: {
    position: 'absolute' as const,
    top: '28px',
    left: '50%',
    transform: 'translateX(-50%)',
    backgroundColor: '#343741',
    color: 'white',
    fontSize: '10px',
    padding: '2px 8px',
    borderRadius: '8px',
    whiteSpace: 'nowrap' as const,
  },
} as const;

// Map Container Styles
export const MAP_CONTAINER_STYLES = {
  BASE: {
    position: 'relative' as const,
    border: '2px dashed #D3DAE6',
    borderRadius: '6px',
    backgroundColor: '#F5F7FA',
    overflow: 'hidden',
    outline: 'none',
  },
  VIEWPORT: {
    position: 'relative' as const,
    transformOrigin: '0 0',
  },
  IMAGE: {
    width: '100%',
    display: 'block',
    position: 'relative' as const,
    zIndex: 0,
    userSelect: 'none' as const,
    transformOrigin: 'center center',
  },
} as const;

// Colors
export const COLORS = {
  BORDER: '#e1e5e9',
  BACKGROUND_LIGHT: '#f8f9fa',
  BACKGROUND_DARK: '#343741',
  DEFAULT_AP_COLOR: '#006BB4',
  WHITE: 'white',
} as const;

// Helper functions for dynamic styles
export const getCursorStyle = (isPanning: boolean, zoomLevel: number): CSSProperties['cursor'] => {
  if (isPanning) return 'grabbing';
  if (zoomLevel > 1) return 'grab';
  return 'default';
};

export const getButtonCursor = (isEnabled: boolean): CSSProperties['cursor'] => {
  return isEnabled ? 'pointer' : 'not-allowed';
};

export const getButtonOpacity = (isEnabled: boolean): number => {
  return isEnabled ? 1 : 0.5;
};

export const getTransition = (isPanning: boolean): string => {
  return isPanning ? 'none' : 'transform 0.1s ease-out';
};
