/**
 * ModalsContainer Component
 * Manages all modals (Node Details, Save Project, Load Project)
 */

import React from 'react';
import { SaveProjectModal } from '@/app/components/pdf-editor';
import { NodeDetails } from '@/features/project-setup/components/ui';
import { PDFFile } from '@/app/components/pdf-editor/types';
import { AccessPointMarkerPoint } from '@/features/access-points';
import type { AccessPointType } from '@/features/access-points';
import type { Project } from '@/types';

interface ModalsContainerProps {
  showNodeDetailsModal: boolean;
  selectedNodeDetails: AccessPointMarkerPoint | null;
  showSaveModal: boolean;
  showLoadModal: boolean;
  projectName: string;
  apiLoading: boolean;
  pdfFile: PDFFile;
  savedProjects: Project[];
  accessPointTypes: AccessPointType[];
  globalAps: AccessPointMarkerPoint[];
  setShowNodeDetailsModal: (show: boolean) => void;
  setShowSaveModal: (show: boolean) => void;
  setShowLoadModal: (show: boolean) => void;
  setProjectName: (name: string) => void;
  startEditingNode: (ap: AccessPointMarkerPoint) => void;
  saveProject: () => Promise<void>;
  loadProject: (project: Project) => Promise<void>;
}

export function ModalsContainer({
  showNodeDetailsModal,
  selectedNodeDetails,
  showSaveModal,
  showLoadModal,
  projectName,
  apiLoading,
  pdfFile,
  savedProjects,
  accessPointTypes,
  globalAps,
  setShowNodeDetailsModal,
  setShowSaveModal,
  setShowLoadModal,
  setProjectName,
  startEditingNode,
  saveProject,
  loadProject
}: ModalsContainerProps) {
  return (
    <>
      {/* Node Details Modal */}
      {showNodeDetailsModal && selectedNodeDetails && (
        <NodeDetails
          setShowNodeDetailsModal={setShowNodeDetailsModal}
          accessPointTypes={accessPointTypes}
          selectedNodeDetails={selectedNodeDetails}
          globalAps={globalAps}
          startEditingNode={startEditingNode}
        />
      )}

      {/* Save Project Modal */}
      <SaveProjectModal
        isOpen={showSaveModal}
        projectName={projectName}
        apiLoading={apiLoading}
        pdfFile={pdfFile}
        onClose={() => setShowSaveModal(false)}
        onSave={saveProject}
        onProjectNameChange={setProjectName}
      />

    </>
  );
}
