/**
 * PDFCropScreen Component
 * Handles PDF cropping, rotation, and viewport adjustment
 */

import React from 'react';
import ZoomPanRotationEditor from '../../ZoomPanRotationEditor';
import type { ViewportAction, PDFFile } from '@/types';

interface PDFCropScreenProps {
  imgsrc: string;
  navigateTo: (screen: string) => void;
  dispatch: React.Dispatch<ViewportAction>;
  setPdfFile: (file: PDFFile) => void;
}

export function PDFCropScreen({
  imgsrc,
  navigateTo,
  dispatch,
  setPdfFile
}: PDFCropScreenProps) {
  return (
    <ZoomPanRotationEditor
      imgsrc={imgsrc}
      navigateTo={navigateTo}
      dd={dispatch}
      setPdfFile={setPdfFile}
    />
  );
}
