/**
 * UploadScreen Component
 * Handles PDF file upload interface
 */

import React from 'react';
import {
  EuiPanel,
  EuiTitle,
  EuiSpacer,
  EuiFlexGroup,
  EuiFlexItem,
  EuiLoadingSpinner,
  EuiText
} from '@elastic/eui';
import { FileUploader } from '../../FileUploader';
import getDict from '@/lib/dict';

const dict = getDict("de");

interface UploadScreenProps {
  currentScreen: string;
  loading: boolean;
  pdfJsLoaded: boolean;
  loadingError: string | null;
  onFileUpload: (files: File[]) => Promise<void>;
}

export function UploadScreen({
  currentScreen,
  loading,
  pdfJsLoaded,
  loadingError,
  onFileUpload
}: UploadScreenProps) {
  return (
    <EuiPanel>
      <EuiTitle size="m">
        <h2>
          {currentScreen === 'PROJECT_SETUP'
            ? dict.mapConfig
            : dict.uploadText + dict.accessPoint}
        </h2>
      </EuiTitle>
      <EuiSpacer size="m" />

      <EuiFlexGroup alignItems="center" gutterSize="m">
        {(
          <FileUploader
            apiLoading={loading}
            onFileUpload={onFileUpload}
            configSetup={false}
          />
        )}
      </EuiFlexGroup>

      {!pdfJsLoaded && !loadingError && (
        <>
          <EuiSpacer size="m" />
          <EuiFlexGroup alignItems="center" gutterSize="s">
            <EuiFlexItem grow={false}>
              <EuiLoadingSpinner size="m" />
            </EuiFlexItem>
            <EuiFlexItem grow={false}>
              <EuiText size="s" color="subdued">
                Loading...
              </EuiText>
            </EuiFlexItem>
          </EuiFlexGroup>
        </>
      )}
    </EuiPanel>
  );
}
