import AccessPointMarkerPoint from '@/app/types/AccessPointMarker';

export interface ViewportState {
  zoomLevel: number;
  panOffset: { x: number; y: number };
  rotation: number;
  isPanning: boolean;
  lastPanPosition: { x: number; y: number };
}

export interface PDFFile {
  name: string;
  size: number;
  uploadedPath?: string;
}

export interface DragItem {
  isNew: boolean;
  type: string;
  name?: string; // Name for existing access points
  accessPoint?: AccessPointMarkerPoint;
  id?: string;
}

export interface TouchDragPreview {
  x: number;
  y: number;
  visible: boolean;
}

export interface AccessPointType {
  id: string;
  name: string;
  color: string;
  icon?: string;
  maxCount?: number;
}

export interface ProjectData {
  name: string;
  accessPoints: Array<{
    id: string;
    type: string;
    name: string;
    floor: string;
    x: number;
    y: number;
    page: number;
  }>;
  currentPage: number;
  timestamp: number;
  pageRotation: number;
  pdfFile: PDFFile;
  viewportState: {
    zoomLevel: number;
    panOffset: { x: number; y: number };
    pageViewports?: Record<number, { zoomLevel: number; panOffset: { x: number; y: number } }>;
  };
}

export interface MapCanvasProps {
  pdfPages: string[];
  currentPage: number;
  accessPoints: AccessPointMarkerPoint[];
  accessPointTypes: AccessPointType[];
  viewport: ViewportState;
  imageDimensions: { width: number; height: number };
  allowNodeMovement: boolean;
  editingNodeId: string | null;
  draggedItem: DragItem | null;
  touchDragPreview: TouchDragPreview;
  touchDragItem: DragItem | null;
  src: string | null;
  onImageLoad: () => void;
  onDrop: (e: React.DragEvent) => void;
  onDragOver: (e: React.DragEvent) => void;
  onWheel: (e: React.WheelEvent) => void;
  onMouseDown: (e: React.MouseEvent) => void;
  onAccessPointDragStart: (e: React.DragEvent, ap: AccessPointMarkerPoint) => void;
  onTouchStartAccessPoint: (e: React.TouchEvent, ap: AccessPointMarkerPoint) => void;
  startEditingNode: (ap: AccessPointMarkerPoint) => void;
  showNodeDetails: (ap: AccessPointMarkerPoint) => void;
  dispatch: React.Dispatch<ViewportAction>;
  containerRef: React.RefObject<HTMLDivElement>;
  mapContainerRef: React.RefObject<HTMLDivElement>;
  mapImageRef: React.RefObject<HTMLImageElement>;
}

export interface ProjectControlsProps {
  projectName: string;
  projectFound: boolean;
  projectUpdated: boolean;
  allowNodeMovement: boolean;
  onSave: () => void;
  onToggleNodeMovement: (value: boolean) => void;
}

// Viewport action types
export type ViewportAction =
  | { type: 'SET_ZOOM'; payload: number }
  | { type: 'ZOOM_IN' }
  | { type: 'ZOOM_OUT' }
  | { type: 'SET_PAN'; payload: { x: number; y: number } }
  | { type: 'START_PAN'; payload: { x: number; y: number } }
  | { type: 'UPDATE_PAN'; payload: { x: number; y: number } }
  | { type: 'END_PAN' }
  | { type: 'ROTATE_LEFT' }
  | { type: 'ROTATE_RIGHT' }
  | { type: 'SET_ROTATION'; payload: number }
  | { type: 'RESET_VIEW' }
  | { type: 'SET_IMAGE_DIMENSIONS'; payload: { width: number; height: number } }
  | { type: 'FIT_TO_VIEW'; payload: { containerWidth: number; containerHeight: number } };

// ViewportControls props
export interface ViewportControlsProps {
  state: {
    viewport: ViewportState;
    imageDimensions: { width: number; height: number };
  };
  dispatch: React.Dispatch<ViewportAction>;
  containerRef: React.RefObject<HTMLDivElement>;
}

// Saved Project type from API
export interface SavedProject extends ProjectData {
  id?: string;
  createdAt?: number;
  updatedAt?: number;
}