type Device = {
  authorized: boolean
  online: boolean
  id: string
  type: DeviceType
  name: string
  password?: string
  mac?: string
  ip?: string
  currentAP?: string
  addedBy: string
  addedAt: string
  signal: number
  firstConnectedAt?: string
  lastConnectedAt?: string
  network?: string
  ipAddress?: string
  bytes_rx?: number
  bytes_tx?: number
  networkName?: string
  appName?: string
}

export const DeviceTypes = ["iot", "laptop", "pc", "phone", "printer", "tablet"] as const;

export type DeviceType = typeof DeviceTypes[number];


export default Device
