const ERROR_CODES: Record<string, string> = {
  // Login errors
  "LOGIN_EXCEPTION_500": " Error AUTH500",
  "LOGIN_EXCEPTION_401": " Error AUTH401",
  // Device errors
  "DEVICE_ADD_EXCEPTION_500": " Error DAD500",
  "DEVICE_ADD_EXCEPTION_401": " Error DAD401",
  "DEVICE_EDIT_EXCEPTION_500": " Error DED500",
  "DEVICE_EDIT_EXCEPTION_401": " Error DED401",
  "DEVICE_FETCH_500": " Error DF500",
  "DEVICE_FETCH_401": " Error DF401",
  "DEVICE_DELETE_500": " Error DL500",
  "DEVICE_DELETE_401": " Error DL401",
  "DEVICE_EXCEPTION_500": " Error D500",

  // Network errors
  "NETWORK_FETCH_500": " Error NF500",
  "NETWORK_FETCH_401": " Error NF401",
  "NETWORK_ADD_500": " Error NA500",
  "NETWORK_ADD_401": " Error NA401",
  "NETWORK_EXCEPTION_500": " Error N500",
  "NETWORK_DELETE_500": " Error NDL500",
  "NETWORK_DELETE_401": " Error NDL401",

  // AccessPoints errors
  "ACCESS_POINT_FETCH_500": " Error APF500",
  "ACCESS_POINT_EXCEPTION_500": " Error APE500",
};

export const getErrorCode = (type: string, status: number = 500) => {
  return ERROR_CODES[`${type}_${status}`] || `${type[0]}000`;
};
export interface ApiError extends Error {
  status?: number ;
}
