const fs = require('fs');
const path = require('path');
const sharp = require('sharp');


const svgFilePath = path.join(__dirname, "public", 'logo.svg');
const outputPath = path.join(__dirname, 'public', 'favicon.ico');


async function generateFavicon() {
  try {

    const svgContent = fs.readFileSync(svgFilePath, 'utf8');

    // Ensure the output directory exists
    const dir = path.dirname(outputPath);
    if (!fs.existsSync(dir)) {
      fs.mkdirSync(dir, { recursive: true });
    }

    // Convert SVG content to a Buffer
    const svgBuffer = Buffer.from(svgContent);

    // Use Sharp to convert the SVG to a 64x64 PNG, then to ICO format
    await sharp(svgBuffer)
      .resize(64, 64) // Resize to 64x64 for a favicon
      .png() // Convert to PNG first
      .toBuffer()
      .then((pngBuffer) => sharp(pngBuffer)
        .toFile(outputPath)); // Save as ICO format

    console.log('Favicon generated successfully!');

  } catch (error) {
    console.error('Error generating favicon:', error);
  }
}

generateFavicon();
