import React from 'react';
import {
  EuiFlexGroup,
  EuiFlexItem,
  EuiFieldText,
  EuiButtonIcon,
} from '@elastic/eui';

interface AccessPointEditFormProps {
  value: string;
  onChange: (value: string) => void;
  onKeyPress: (e: React.KeyboardEvent<HTMLInputElement>) => void;
  onSave: () => void;
  onCancel: () => void;
}

export const AccessPointEditForm: React.FC<AccessPointEditFormProps> = ({
  value,
  onChange,
  onKeyPress,
  onSave,
  onCancel,
}) => {
  return (
    <EuiFlexGroup gutterSize="xs" alignItems="center" responsive={false}>
      {/* Input Field */}
      <EuiFlexItem>
        <EuiFieldText
          value={value}
          onChange={(e) => onChange(e.target.value)}
          onKeyDown={onKeyPress}
          compressed
          autoFocus
          style={{ fontSize: '14px' }}
          onClick={(e) => e.stopPropagation()}
          placeholder="Enter floor number..."
        />
      </EuiFlexItem>

      {/* Save Button */}
      <EuiFlexItem grow={false}>
        <EuiButtonIcon
          iconType="check"
          color="success"
          size="s"
          onClick={(e) => {
            e.stopPropagation();
            onSave();
          }}
          aria-label="Save floor number"
        />
      </EuiFlexItem>

      {/* Cancel Button */}
      <EuiFlexItem grow={false}>
        <EuiButtonIcon
          iconType="cross"
          color="danger"
          size="s"
          onClick={(e) => {
            e.stopPropagation();
            onCancel();
          }}
          aria-label="Cancel edit"
        />
      </EuiFlexItem>
    </EuiFlexGroup>
  );
};