import React from 'react';
import {
  EuiFlexGroup,
  EuiFlexItem,
  EuiTitle,
  EuiIcon,
} from '@elastic/eui';
import getDict from '@/lib/dict';

const dict = getDict('de');

export const AccessPointListHeader: React.FC = () => {
  return (
    <EuiFlexGroup alignItems="center" gutterSize="s" responsive={false}>
      <EuiFlexItem grow={false}>
        <EuiIcon type="bullseye" size="m" color="primary" />
      </EuiFlexItem>
      <EuiFlexItem>
        <EuiTitle size="xs">
          <h3>
            {dict.current} {dict.accessPoint}
          </h3>
        </EuiTitle>
      </EuiFlexItem>
    </EuiFlexGroup>
  );
};