/**
 * Access Point Icon Component
 *
 * Displays the access point icon with an online/offline status indicator.
 */

import React from 'react';
import { EuiIcon } from '@elastic/eui';
import { COLORS } from './constants';

export interface AccessPointIconProps {
  isAtLimit: boolean;
  isOnline: boolean;
  draggable?: boolean;
}

export const AccessPointIcon: React.FC<AccessPointIconProps> = ({
  isAtLimit,
  isOnline,
  draggable = true,
}) => (
  <div
    style={{ position: 'relative', display: 'inline-block' }}
    draggable={draggable && !isAtLimit}
  >
    <EuiIcon
      type="bullseye"
      size="l"
      color={isAtLimit ? 'subdued' : 'primary'}
    />
    <div
      style={{
        position: 'absolute',
        bottom: '-2px',
        right: '-2px',
        width: '10px',
        height: '10px',
        borderRadius: '50%',
        backgroundColor: isOnline ? COLORS.online : COLORS.offline,
        border: '2px solid white',
        opacity: isAtLimit ? 0.6 : 1,
      }}
    />
  </div>
);
