import React from 'react';
import { EuiFlexGroup, EuiFlexItem, EuiButton, EuiButtonEmpty } from '@elastic/eui';

export interface TourNavigationControlsProps {
  currentStep: number;
  totalSteps: number;
  onPrev: () => void;
  onEnd: () => void;
  onNext: () => void;
  showBack?: boolean;
}

export const TourNavigationControls: React.FC<TourNavigationControlsProps> = ({
  currentStep,
  totalSteps,
  onPrev,
  onEnd,
  onNext,
  showBack = true,
}) => {
  const isLastStep = currentStep === totalSteps - 1;

  return (
    <EuiFlexGroup justifyContent="spaceBetween" gutterSize="s">
      {showBack && (
        <EuiFlexItem grow={false}>
          <EuiButtonEmpty
            size="s"
            onClick={onPrev}
            disabled={currentStep === 0}
            iconType="arrowLeft"
          >
            Zurück
          </EuiButtonEmpty>
        </EuiFlexItem>
      )}
      <EuiFlexItem grow={false}>
        <EuiButtonEmpty size="s" onClick={onEnd} color="text">
          Tour beenden
        </EuiButtonEmpty>
      </EuiFlexItem>
      <EuiFlexItem grow={false}>
        <EuiButton size="s" onClick={onNext} fill>
          {isLastStep ? 'Fertig' : `Weiter (${currentStep + 1}/${totalSteps})`}
        </EuiButton>
      </EuiFlexItem>
    </EuiFlexGroup>
  );
};
