/**
 * Constants for AccessPointTypes components
 */

import { TourStep } from './types';

export const TOUR_LOCAL_STORAGE_KEY = 'accessPointTypesTourCompleted';
export const TOUR_AUTO_START_DELAY = 1000;

export const COLORS = {
  online: '#10b981',
  offline: '#ef4444',
  border: {
    online: '#00BFB3',
    offline: '#ef4444',
  },
  text: {
    normal: '#343741',
    subdued: '#69707D',
  },
  background: {
    normal: 'white',
    disabled: '#f7f8fc',
    container: '#f5f7fa',
  },
} as const;

export const TOUR_STEPS: TourStep[] = [
  {
    step: 1,
    title: 'Verfügbare Access Points',
    content: 'Hier sehen Sie alle verfügbaren Access Point-Typen, die Sie auf Ihrem Plan platzieren können. Jeder Typ hat eine eindeutige Farbe und zeigt den Online-Status an.',
  },
  {
    step: 2,
    title: 'Drag & Drop',
    content: 'Ziehen Sie einen Access Point mit der Maus auf Ihren Plan. Auf Touch-Geräten können Sie den Access Point antippen und auf die gewünschte Position ziehen.',
  },
  {
    step: 3,
    title: 'Status-Anzeige',
    content: 'Der farbige Punkt zeigt den Status: Grün = Online, Rot = Offline. Der Badge zeigt, wie viele Access Points dieses Typs bereits platziert wurden.',
  },
  {
    step: 4,
    title: 'Limit & Badge',
    content: 'Der Badge zeigt den Zähler (z.B. 0/1 oder 1/1). Wenn das Limit erreicht ist, wird der Access Point gesperrt (Schloss-Symbol) und kann nicht mehr platziert werden.',
  },
];