/**
 * Type definitions for AccessPointTypes components
 */

export interface AccessPointType {
  id: string;
  name: string;
  online: boolean;
}

export interface AccessPointMarker {
  id: string;
  type: string;
}

export interface AccessPointTypesProps {
  accessPointTypes: AccessPointType[];
  isTypeAtLimit: (typeId: string, accessPoints: AccessPointMarker[]) => boolean;
  getTypeCount: (typeId: string, accessPoints: AccessPointMarker[]) => number;
  handleDragStart: (e: React.DragEvent, typeId: string) => void;
  handleTouchStartType: (e: React.TouchEvent, typeId: string) => void;
  accessPoints: AccessPointMarker[];
}

export interface TourStep {
  step: number;
  title: string;
  content: string;
}

export interface UseTourManagerReturn {
  isTourActive: boolean;
  currentTourStep: number;
  handleTourNext: () => void;
  handleTourPrev: () => void;
  handleTourEnd: () => void;
  resetTour: () => void;
}