"use client";

import { jwtDecode, JwtPayload } from "jwt-decode";
import Cookies from "js-cookie";
export interface CustomJwtPayload extends JwtPayload {
  exp: number; // Expiration time (Unix timestamp)
  email: string;
}

export function getToken() {
  const token = Cookies.get("apiKey");
  if (!token) return null;

  try {
    const decoded = jwtDecode<CustomJwtPayload>(token); // Decode JWT and extract expiration time
    const isExpired = decoded.exp * 1000 < Date.now();

    if (isExpired) {
      Cookies.remove("apiKey"); // Remove expired token
      return null;
    }
    Cookies.set("userEmail", decoded.email);
    return token;
  } catch (error) {
    console.log(error);
    Cookies.remove("apiKey"); // Remove invalid token
    return null;
  }
}
export function setToken() {
  Cookies.remove("apiKey");
}
