import React from 'react';
import { m } from 'framer-motion';
import {
  EuiPanel,
  EuiTitle,
  EuiText,
  EuiSpacer,
  EuiButton,
  EuiIcon,
  EuiFlexGroup,
  EuiFlexItem,
} from '@elastic/eui';
import { animations } from '@/features/project-setup/utils';
import getDict from '@/lib/dict';

const dict = getDict('de');

interface CompleteScreenProps {
  onFinish: () => void;
}

export const CompleteScreen: React.FC<CompleteScreenProps> = ({ onFinish }) => {
  return (
    <m.div
      key="complete"
      variants={animations.pageVariants}
      initial="initial"
      animate="in"
      exit="out"
      style={{
        maxWidth: '640px',
        margin: '0 auto',
        padding: '32px 16px',
      }}
    >
      <m.div
        initial={{ opacity: 0, y: 40 }}
        animate={{ opacity: 1, y: 0 }}
        transition={{ duration: 0.8, ease: [0.22, 1, 0.36, 1] }}
      >
        <EuiPanel
          hasBorder
          hasShadow={false}
          paddingSize="none"
          style={{
            background: 'linear-gradient(to bottom, #ffffff 0%, #f8f9fa 100%)',
            borderRadius: '20px',
            padding: '56px 48px',
            textAlign: 'center',
            position: 'relative',
            overflow: 'hidden',
            border: '1px solid #e0e5ea',
          }}
        >
          {/* Animated Background Circles */}
          <m.div
            animate={{
              scale: [1, 1.2, 1],
              opacity: [0.03, 0.05, 0.03],
            }}
            transition={{
              duration: 8,
              repeat: Infinity,
              ease: 'easeInOut',
            }}
            style={{
              position: 'absolute',
              top: '-50%',
              right: '-20%',
              width: '500px',
              height: '500px',
              borderRadius: '50%',
              background: 'radial-gradient(circle, #00BFB3 0%, transparent 70%)',
            }}
          />
          <m.div
            animate={{
              scale: [1, 1.3, 1],
              opacity: [0.02, 0.04, 0.02],
            }}
            transition={{
              duration: 10,
              repeat: Infinity,
              ease: 'easeInOut',
              delay: 1,
            }}
            style={{
              position: 'absolute',
              bottom: '-30%',
              left: '-10%',
              width: '400px',
              height: '400px',
              borderRadius: '50%',
              background: 'radial-gradient(circle, #0077CC 0%, transparent 70%)',
            }}
          />

          {/* Success Icon */}
          <m.div
            initial={{ opacity: 0, scale: 0.5, rotate: -180 }}
            animate={{ opacity: 1, scale: 1, rotate: 0 }}
            transition={{
              delay: 0.2,
              duration: 0.8,
              type: 'spring',
              stiffness: 120,
              damping: 12,
            }}
            style={{ position: 'relative', zIndex: 1 }}
          >
            <m.div
              animate={{
                boxShadow: [
                  '0 8px 32px rgba(0, 191, 179, 0.2)',
                  '0 8px 48px rgba(0, 191, 179, 0.35)',
                  '0 8px 32px rgba(0, 191, 179, 0.2)',
                ],
              }}
              transition={{
                duration: 3,
                repeat: Infinity,
                ease: 'easeInOut',
              }}
              style={{
                width: '120px',
                height: '120px',
                margin: '0 auto 32px',
                background: 'linear-gradient(135deg, #00BFB3 0%, #00a89d 100%)',
                borderRadius: '50%',
                display: 'flex',
                alignItems: 'center',
                justifyContent: 'center',
                border: '3px solid #e0e5ea',
              }}
            >
              <EuiIcon type="checkInCircleFilled" size="xxl" color="white" style={{ fontSize: '64px' }} />
            </m.div>
          </m.div>

          {/* Title */}
          <m.div
            initial={{ opacity: 0, y: 30 }}
            animate={{ opacity: 1, y: 0 }}
            transition={{ delay: 0.4, duration: 0.7, ease: [0.22, 1, 0.36, 1] }}
            style={{ position: 'relative', zIndex: 1 }}
          >
            <EuiTitle size="l">
              <h1
                style={{
                  color: '#1a1c21',
                  margin: 0,
                  fontWeight: 600,
                  letterSpacing: '-0.02em',
                }}
              >
                {dict.mapSavedText}
              </h1>
            </EuiTitle>
            <EuiSpacer size="m" />
            <m.div
              initial={{ opacity: 0 }}
              animate={{ opacity: 1 }}
              transition={{ delay: 0.6, duration: 0.7 }}
            >
              <EuiText size="m" style={{ color: '#69707d', fontWeight: 400 }}>
                {dict.redirecting}..
              </EuiText>
            </m.div>
          </m.div>

          <EuiSpacer size="xl" />

          {/* Success Features */}
          <m.div
            initial={{ opacity: 0, y: 20 }}
            animate={{ opacity: 1, y: 0 }}
            transition={{ delay: 0.8, duration: 0.5 }}
            style={{ position: 'relative', zIndex: 1 }}
          >
            <EuiFlexGroup
              direction="column"
              alignItems="center"
              gutterSize="s"
              responsive={false}
              style={{
                background: '#F5F7FA',
                borderRadius: '12px',
                padding: '20px',
                maxWidth: '400px',
                margin: '0 auto',
                border: '1px solid #e0e5ea',
              }}
            >
              <EuiFlexItem grow={false}>
                <EuiFlexGroup gutterSize="s" alignItems="center" responsive={false}>
                  <EuiFlexItem grow={false}>
                    <EuiIcon type="check" color="success" />
                  </EuiFlexItem>
                  <EuiFlexItem grow={false}>
                    <EuiText size="s" style={{ color: '#69707d' }}>
                      Projekt erfolgreich gespeichert
                    </EuiText>
                  </EuiFlexItem>
                </EuiFlexGroup>
              </EuiFlexItem>

              <EuiFlexItem grow={false}>
                <EuiFlexGroup gutterSize="s" alignItems="center" responsive={false}>
                  <EuiFlexItem grow={false}>
                    <EuiIcon type="check" color="success" />
                  </EuiFlexItem>
                  <EuiFlexItem grow={false}>
                    <EuiText size="s" style={{ color: '#69707d' }}>
                      Alle Änderungen wurden übernommen
                    </EuiText>
                  </EuiFlexItem>
                </EuiFlexGroup>
              </EuiFlexItem>

              <EuiFlexItem grow={false}>
                <EuiFlexGroup gutterSize="s" alignItems="center" responsive={false}>
                  <EuiFlexItem grow={false}>
                    <EuiIcon type="check" color="success" />
                  </EuiFlexItem>
                  <EuiFlexItem grow={false}>
                    <EuiText size="s" style={{ color: '#69707d' }}>
                      Bereit zum Fortfahren
                    </EuiText>
                  </EuiFlexItem>
                </EuiFlexGroup>
              </EuiFlexItem>
            </EuiFlexGroup>
          </m.div>

          <EuiSpacer size="xl" />

          {/* Finish Button */}
          <m.div
            initial={{ opacity: 0, scale: 0.95 }}
            animate={{ opacity: 1, scale: 1 }}
            transition={{ delay: 1, duration: 0.4 }}
            style={{ position: 'relative', zIndex: 1 }}
          >
            <EuiButton
              fill
              color="primary"
              onClick={onFinish}
              size="m"
              iconType="arrowRight"
              iconSide="right"
              style={{
                minWidth: '200px',
                background: 'linear-gradient(135deg, #00BFB3 0%, #00a89d 100%)',
              }}
            >
              Finish
            </EuiButton>
          </m.div>

          {/* Decorative Bottom Line */}
          <m.div
            initial={{ scaleX: 0 }}
            animate={{ scaleX: 1 }}
            transition={{ delay: 1.2, duration: 0.8, ease: 'easeOut' }}
            style={{
              position: 'absolute',
              bottom: 0,
              left: '50%',
              transform: 'translateX(-50%)',
              width: '60%',
              height: '3px',
              background: 'linear-gradient(90deg, transparent 0%, #00BFB3 50%, transparent 100%)',
              borderRadius: '3px',
            }}
          />
        </EuiPanel>
      </m.div>
    </m.div>
  );
};