import React, { useState } from "react";
import { SCREEN_TYPES } from "../utils/constants";
import { useScreenManager } from "./useScreenManager";

export const useAppState = () => {

  const screenManager = useScreenManager();
  const [appData, setAppData] = useState({});

  // Expose screen state and additional app state
  return {
    ...screenManager,
    appData,
    setAppData,
    // Computed properties
    canGoBack: screenManager.currentScreen !== SCREEN_TYPES.WELCOME,
    isInSetupFlow: screenManager.currentScreen.includes('step'),
  };
};

function calculateProgress(currentScreen: string) {
  throw new Error("Function not implemented.");
}
