import Network from '@/app/types/Network';
import { api, APIError } from '@/lib/api';
import type { CreateNetworkData } from '@/lib/api/endpoints/networks';
import { useState } from 'react';

export const useNetworkManager = () => {
  const [networkName, setNetworkName] = useState('');
  const [networkType, setNetworkType] = useState('');
  const [savedProjects, setSavedProjects] = useState<Network[]>([]);
  const [showSaveModal, setShowSaveModal] = useState(false);
  const [showLoadModal, setShowLoadModal] = useState(false);
  const [apiLoading, setApiLoading] = useState(false);
  const [saved, setSaved] = useState(false);

  const saveNetwork = async (data: CreateNetworkData): Promise<Network | null> => {
    try {
      setApiLoading(true);
      const result = await api.networks.createNetwork(data);
      setShowSaveModal(false);
      setNetworkName('');
      setSaved(true);
      return result;
    } catch (error) {
      console.error('Error saving network:', error);
      setSaved(false);
      if (error instanceof APIError) {
        // Re-throw API errors for caller to handle
        throw error;
      }
      throw error;
    } finally {
      setApiLoading(false);
    }
  };

  const resetSaved = () => {
    setSaved(false);
  };

  return {
    networkName,
    setNetworkName,
    networkType,
    setNetworkType,
    savedProjects,
    setSavedProjects,
    showSaveModal,
    setShowSaveModal,
    showLoadModal,
    setShowLoadModal,
    apiLoading,
    setApiLoading,
    saveNetwork,
    saved,
    resetSaved
  };
};
