import { useLoader } from '@/shared/providers';
import { useState, useCallback } from 'react';
import { SCREEN_TYPES } from '../utils/constants';

export const useScreenManager = () => {
  const [selectedOption, setSelectedOption] = useState<string | null>(null);
  const { currentScreen, setCurrentScreen } = useLoader();
  const navigateTo = useCallback((screen: string) => {
    setCurrentScreen(screen)
  }, [setCurrentScreen]);
  const selectOption = useCallback((option: string) => setSelectedOption(option), []);
  const reset = useCallback(() => {
    setCurrentScreen(SCREEN_TYPES.WELCOME);
    setSelectedOption(null);
  }, [setCurrentScreen]);
  const isCurrentScreen = useCallback((screen: string) => currentScreen === screen, [currentScreen]);
  const getCurrentScreenInfo = useCallback(() => ({
    screen: currentScreen,
    isLoading: currentScreen.includes('loading'),
    isComplete: currentScreen === SCREEN_TYPES.COMPLETE,
    isSetup: currentScreen.includes('step') || currentScreen === SCREEN_TYPES.PROJECT_SETUP
  }), [currentScreen]);

  return { selectedOption, navigateTo, selectOption, reset,     isCurrentScreen,
    getCurrentScreenInfo };
};
