/**
 * Authentication API Endpoints
 * All authentication-related API calls
 */

import type { APIClient } from '../client';
import type { LoginRequest, LoginResponse, APIResponse } from '../types';

export class AuthAPI {
  constructor(private client: APIClient) {}

  /**
   * Login with username and password
   */
  async login(credentials: LoginRequest): Promise<LoginResponse> {
    return this.client.post<LoginResponse>('/auth/login', credentials);
  }

  /**
   * Logout current user
   */
  async logout(): Promise<APIResponse<void>> {
    return this.client.post<APIResponse<void>>('/auth/logout');
  }

  /**
   * Verify current session
   */
  async verifySession(): Promise<APIResponse<{ valid: boolean }>> {
    return this.client.get<APIResponse<{ valid: boolean }>>('/auth/verify');
  }

}
