/**
 * Application configuration
 * Centralizes environment variables and API endpoints
 */

export const config = {
  api: {
    baseUrl: process.env.NEXT_PUBLIC_API_BASE_URL || 'http://localhost:3000/api',
    edgeBaseUrl: process.env.NEXT_PUBLIC_API_EDGE_BASE_URL || '/api/edge',
    endpoints: {
      projects: process.env.NEXT_PUBLIC_API_PROJECTS_ENDPOINT || '/projects',
      uploads: process.env.NEXT_PUBLIC_API_UPLOADS_ENDPOINT || '/projects/uploads/pdf',
    }
  },
  features: {
    enablePdfUpload: process.env.NEXT_PUBLIC_ENABLE_PDF_UPLOAD !== 'false',
    maxPdfSizeMB: parseInt(process.env.NEXT_PUBLIC_MAX_PDF_SIZE_MB || '50', 10)
  }
};
