export interface Dict {
  dashboard: string
  networks: string
  network: string
  crop: string
  cropText: string
  devices: string
  device: string
  devicesInNetwork: string
  deviceAddError: string
  networkAddError: string
  antennas: string
  antenna: string
  skip: string
  internet: string
  networkInfo: string
  floor: string
  logs: string
  support: string
  server: string
  show: string
  loggedInAs: string
  logout: string
  login: string
  loginError: string
  invalidCredentials: string
  email: string
  password: string
  download: string
  upload: string
  add: string
  remove: string
  confirm: string
  cancel: string
  cancelBtn: string
  create: string
  delete: string
  deviceDeleteToast: string
  networkDeleteToast: string
  deviceFetchToast: string
  deviceFetchToastFail: string
  networkFetchToastFail: string
  deviceAddToast: string,
  current: string,
  networkAddToast: string,
  networkFetchToast: string
  deviceDeleted: string
  networkDeleted: string
  edit: string
  editName: string
  editDevice: string
  addDevice: string
  removeDevice: string
  editNetwork: string
  addNetwork: string
  removeNetwork: string
  signal: string
  signalStrengthBad: string
  signalStrengthModerate: string
  signalStrengthGood: string
  signalStrengthPerfect: string
  online: string,
  fit: string,
  offline: string,
  registered: string,
  uploaded: string,
  downloaded: string,
  inTheLast: string,
  dashboardInternetStatus: string
  dashboardDevicesStatus: string
  dashboardTrafficStatus: string
  name: string
  noAccessPoint: string
  noProject: string
  projectNameText: string
  projectFound: string
  type: string
  macAddress: string
  ipAddress: string
  currentAntenna: string
  addedBy: string
  addedAt: string
  firstConnectedAt: string
  lastConnectedAt: string
  connectedDevices: string
  actions: string
  iot: string
  laptop: string
  pc: string
  phone: string
  printer: string
  tablet: string
  selectDeviceType: string
  guest: string
  business: string
  selectNetworkType: string
  networkMap: string
  userManual: string
  supportEmail: string
  supportHotline: string
  up: string
  down: string
  accessPoint: string
  authenticated: string
  clientStats: string
  total: string
  required: string
  unregistered: string
  projectSaved: string
  apFetchToastFail: string
  refreshData: string
  refreshDataEnabled: string
  refreshDataDisabled: string
  loginText: string
  search: string
  clickUpload: string
  load: string
  loginFailed: string
  welcome: string
  setup: string
  getStarted: string
  map: string
  uploadText: string
  available: string
  continue: string
  pdf: string
  saving: string
  detected: string
  fileAdded: string
  mapConfig: string
  apLoad: string
  wait: string
  redirecting: string
  autoRedirect: string
  mapSavedText: string
  clear: string
  limit: string
  allowMoving: string,
  drag: string
  mapLoad: string
  noNetwork: string
  info: string
  update: string
  networkLoad: string
  found: string
  saveProject: string
  loadProject: string
  newProject: string
  viewLegend: string
  close: string
  dragText: string
  nodeMovementText: string
  mapEditor: string
  nodeMovementText2: string
  zoomText: string
  panText: string
  nextStep: string
  rigthClick: string
  finalStep: string
  fitToView: string
  direction: string
  directionText: string
}

const dictDE: Dict = {
  welcome: "Willkommen in ",
  found: "gefunden !",
  crop: "Zuschneiden",
  cropText: "Sie haben nun die Möglichkeit, das PDF zuzuschneiden oder einfach die aktuelle Größe zu bestätigen!",
  fitToView: "Ansicht anpassen",
  finalStep: "Letzter Schritt ",
  setup: "Klicken Sie auf „Erste Schritte“, um mit der Konfiguration zu beginnen!",
  getStarted: "Erste Schritte",
  map: "Karte Konfiguration",
  skip: "Überspringen",
  direction: "Drehung bestätigen",
  directionText: "Bitte drehen Sie das Bild in die gewünschte Richtung",
  uploadText: "Uploaden Sie eine Karte für Ihre ",
  available: "verfügbar",
  drag: "auf Karte ziehen",
  networkInfo: "Einrichten Sie ein neues Buisness Netzwerk auf",
  projectFound: "Project gefunden!",
  floor: "Etage",
  info: "Informationen",
  limit: "Limit erreicht",
  continue: "Weitermachen",
  clear: "Alle Punkte löschen",
  pdf: "Nur PDF format!",
  invalidCredentials: "Ungültige Anmeldeinformationen. Bitte überprüfen Sie Ihre E-Mail und Ihr Passwort",
  fileAdded: "Karte erfolgreich hinzugefügt!",
  mapSavedText: "Karte erfolgreich gespeichert!",
  wait: "Bitte warten",
  redirecting: "Weiterleitung zur Startseite",
  autoRedirect: "Automatische Weiterleitung",
  mapConfig: "Platzieren Sie den Zugangspunkt per Drag & Drop auf der Karte!",
  apLoad: "Suche nach Zugangspunkten",
  mapLoad: "Suche nach bestehenden Projekten",
  projectNameText: "Geben Sie Ihren Projektnamen ein",
  dashboard: "Übersicht",
  load: "Load",
  detected: "erkannt",
  noNetwork: "Kein Netzwerk gefunden!",
  networks: "Netzwerke",
  show: "Es werden",
  network: "Netzwerk",
  devices: "Geräte",
  current: "Aktuell",
  device: "Gerät",
  devicesInNetwork: "Geräte im Netzwerk",
  antennas: "Antennen",
  antenna: "Antenne",
  internet: "Internet",
  logs: "Logbuch",
  support: "Support",
  server: "Server",
  loggedInAs: "eingeloggt als",
  logout: "Ausloggen",
  login: "einloggen",
  loginError: "Fehler ist aufgetreten",
  email: "E-Mail",
  password: "Passwort",
  download: "download",
  upload: "upload",
  add: "Hinzufügen",
  remove: "Entfernen",
  confirm: "Ja",
  cancel: "Nein",
  cancelBtn: "Abbrechen",
  saving: "Speichern",
  create: "erstellen",
  delete: "Löschen",
  deviceDeleteToast: "Gerät mit ID konnte nicht gelöscht werden ",
  networkDeleteToast: "Netzwerk mit ID konnte nicht gelöscht werden ",
  deviceFetchToast: "Gerät mit ID konnte nicht abgerufen werden",
  deviceFetchToastFail: "Geräte konnten nicht abgerufen werden",
  deviceAddToast: "Gerät hinzugefügt",
  networkAddToast: "Netzwerk hinzugefügt",
  networkFetchToastFail: "Netzwerk konnten nicht abgerufen werden",
  networkFetchToast: "Netzwerk mit ID konnte nicht abgerufen werden",
  deviceAddError: "Fehler beim Hinzufügen eines Geräts",
  networkAddError: "Fehler beim Hinzufügen eine Netzwerk",
  deviceDeleted: "Gerät gelöscht",
  networkDeleted: "Netzwerk gelöscht",
  edit: "bearbeiten",
  editName: "Namen bearbeiten",
  editDevice: "Gerät bearbeiten",
  addDevice: "Gerät hinzufügen",
  removeDevice: "Gerät entfernen",
  editNetwork: "Netzwerk bearbeiten",
  addNetwork: "Netzwerk hinzufügen",
  removeNetwork: "Netzwerk entfernen",
  signal: "Empfang",
  signalStrengthBad: "schechter Empfang",
  signalStrengthModerate: "mittelmäßiger Empfang",
  signalStrengthGood: "guter Empfang",
  signalStrengthPerfect: "Perfekt Empfang",
  online: "Online",
  offline: "Offline",
  registered: "registriert",
  uploaded: "geuploaded",
  clickUpload: "Klicken Sie hier, um eine PDF-Datei hochzuladen",
  downloaded: "gedownloaded",
  inTheLast: "in den letzten",
  dashboardInternetStatus: "Internet Status",
  dashboardDevicesStatus: "Geräte Info",
  dashboardTrafficStatus: "Datenverbrauch",
  noAccessPoint: "Kein Zugangspunkten gefunden!",
  noProject: "Kein Projekt gefunden!",
  name: "Name",
  type: "Typ",
  macAddress: "MAC-Adresse",
  ipAddress: "IP-Adresse",
  currentAntenna: "Verbunden mit Antenne",
  addedBy: "hinzugeügt von",
  addedAt: "hinzugefügt am",
  firstConnectedAt: "Erste Verbindung am",
  lastConnectedAt: "Letze Verbindung am",
  saveProject: "Projekt Speichern",
  projectSaved: "Projekt erfolgreich gespeichert!",
  viewLegend: "Legende Anzeigen",
  loadProject: "Projekt Laden",
  newProject: "Neu Projekt",
  connectedDevices: "Verbundene Geräte",
  actions: "Aktionen",
  iot: "IoT",
  fit: "Ansicht anpassen",
  laptop: "Laptop",
  pc: "PC",
  phone: "Handy",
  printer: "Drucker",
  tablet: "Tablet",
  selectDeviceType: "Gerätetyp auswählen",
  guest: "Gäste",
  business: "Business",
  selectNetworkType: "Netzwerk auswählen",
  networkMap: "Netzwerkkarte",
  userManual: "Nutzerhandbuch",
  supportEmail: "Support-E-Mail",
  supportHotline: "Support-Hotline",
  up: "Upload",
  down: "Download",
  loginText: "Geben Sie Ihre Anmeldeinformationen ein, um auf Ihr Konto zuzugreifen",
  accessPoint: "Zugangspunkt",
  authenticated: "Authentifiziert",
  allowMoving: "Verschieben von Knoten zulassen",
  mapEditor: "Karteneditor",
  clientStats: "Kundenstatistiken",
  networkLoad: "Such nach Netzwerken",
  total: "Total",
  required: "Pflichtfeld",
  unregistered: "Nicht Registriert",
  apFetchToastFail: "Zugangspunkt konnten nicht abgerufen werden",
  refreshData: "Daten aktualisieren",
  refreshDataEnabled: "Die Daten werden aktualisiert",
  refreshDataDisabled: "Die Daten werden nicht aktualisiert",
  search: "Suchen nach Namen",
  update: "Aktualisieren",
  nextStep: "Nächster Schritt",
  close: "Schließen",
  loginFailed: "Bitte bestätigen Sie Ihre Anmeldedaten",
  dragText: "Ziehen Sie Zugangspunkte auf die Karte, um sie hinzuzufügen.",
  nodeMovementText: "Knotenbewegung deaktiviert (zum Aktivieren oben umschalten).",
  nodeMovementText2: "Ziehen Sie vorhandene Punkte, um sie zu verschieben.",
  zoomText: "Strg+Klicken und Ziehen zum Schwenken.",
  panText: " Klicken und ziehen Sie, um beim Heranzoomen zu schwenken.",
  rigthClick: " Klicken Sie mit der rechten Maustaste auf Zugriffspunkte für Optionen."
};

const dictEN: Dict = {
  welcome: "Welcome in ",
  found: "found !",
  cropText: "You now have the option to crop the pdf or just confirm the current size!",
  crop: "Crop",
  fitToView: "Fit To View",
  info: "Information",
  networkInfo: "Set up a new professional network",
  setup: "Click on get started to start the configuring !",
  getStarted: "Get Started",
  update: "Update",
  close: "Close",
  map: "Map Configuration",
  uploadText: "Upload a map for your ",
  available: "available",
  drag: "Drag to map",
  limit: "Limit reached",
  wait: "Please wait",
  clear: "Clear All Point",
  redirecting: "Redirecting to home page",
  autoRedirect: "Automatic redirecting...",
  clickUpload: "Click to upload a file",
  continue: "Continue",
  nextStep: "Next Step",
  pdf: "Only PDF format!",
  skip: "Skip",
  fileAdded: "PDF loaded successfully !",
  mapConfig: "Place the Access Point on the map by drag and drop!",
  mapSavedText: "Map saved successfully!",
  saveProject: "Save Project",
  loadProject: "Load Project",
  newProject: "New Project",
  viewLegend: "View Legend",
  apLoad: "Searching for access points",
  allowMoving: "Allow moving nodes",
  networkLoad: "Searching for Networks",
  projectNameText: "Enter your project name",
  mapLoad: "Searching for existing projects",
  dashboard: "dashboard",
  load: "Load",
  networks: "networks",
  network: "network",
  devices: "devices",
  noNetwork: "No Nettwork found!",
  noAccessPoint: "No Access Points found!",
  noProject: "No Project found!",
  device: "device",
  mapEditor: "Map Editor",
  floor: "floor",
  invalidCredentials: "Invalid credentials. Please check your email and password.",
  projectFound: "Project found!",
  devicesInNetwork: "devices in the network",
  antennas: "antennas",
  antenna: "antenna",
  internet: "internet",
  logs: "logs",
  support: "support",
  server: "server",
  loggedInAs: "logged in as",
  logout: "logout",
  login: "login",
  loginError: "Error occurred",
  email: "email",
  password: "password",
  download: "download",
  upload: "upload",
  add: "add",
  remove: "remove",
  confirm: "Yes",
  cancel: "No",
  cancelBtn: "Cancel",
  create: "create",
  delete: "delete",
  fit: "Fit View",
  deviceDeleteToast: "Failed to delete device with ID",
  networkDeleteToast: "Failed to delete device with ID",
  deviceFetchToast: "Failed to fetch device with ID",
  deviceFetchToastFail: "Failed to fetch devices",
  deviceAddToast: "Device Added",
  networkAddToast: "Network Added",
  deviceAddError: "Error adding a device",
  networkAddError: "Error adding a network",
  networkFetchToastFail: "Failed to fetch network",
  networkFetchToast: "Failed to fetch network with ID",
  deviceDeleted: "Device deleted",
  networkDeleted: "Network deleted",
  edit: "edit",
  editName: "edit name",
  editDevice: "edit device",
  addDevice: "add device",
  removeDevice: "remove device",
  editNetwork: "edit network",
  addNetwork: "add network",
  removeNetwork: "remove network",
  signal: "signal",
  signalStrengthBad: "bad signal",
  signalStrengthModerate: "moderate signal",
  signalStrengthGood: "good signal",
  signalStrengthPerfect: "Perfect signal",
  online: "online",
  offline: "offline",
  registered: "registered",
  uploaded: "uploaded",
  downloaded: "downloaded",
  inTheLast: "in the last",
  dashboardInternetStatus: "internet status",
  dashboardDevicesStatus: "device info",
  dashboardTrafficStatus: "data traffic",
  name: "name",
  type: "type",
  macAddress: "MAC address",
  ipAddress: "IP address",
  current: "Current",
  unregistered: "Unregistered",
  currentAntenna: "connected to antenna",
  addedBy: "added by",
  addedAt: "added at",
  firstConnectedAt: "first connected at",
  lastConnectedAt: "last connected at",
  connectedDevices: "Connected Devices",
  actions: "actions",
  iot: "IoT",
  laptop: "Laptop",
  pc: "PC",
  phone: "Phone",
  printer: "Printer",
  tablet: "Tablet",
  selectDeviceType: "select device type",
  guest: "guest",
  business: "business",
  selectNetworkType: "select network",
  networkMap: "network map",
  userManual: "user manual",
  supportEmail: "support email",
  supportHotline: "support hotline",
  up: "Up",
  down: "Down",
  accessPoint: "Access Point",
  authenticated: "Authenticated",
  clientStats: "client Stats",
  total: "Total",
  required: "Required field",
  apFetchToastFail: "Failed to fetch access points",
  refreshData: "Refresh Data",
  refreshDataEnabled: "The data will be refreshed.",
  refreshDataDisabled: "The data will not be refreshed.",
  search: "Search by name.",
  loginFailed: "Please verify your credentials.",
  loginText: "Enter your credentials to access your account",
  saving: "Saving",
  dragText: "Drag access points to the map to add them",
  nodeMovementText: "Drag access points onto the map to add them",
  nodeMovementText2: "Drag existing points to move them.",
  zoomText: "To zoom in/out, use Ctrl+Mouse Wheel or above buttons.",
  panText: "• Click and drag to pan when zoomed in.",
  rigthClick: "• Right-click access points for options.",
  finalStep: "Final Step",
  direction: "Confirm Rotation",
  directionText: "Please rotate the image to the desired direction.",
  detected: "detected",
  show: "showing",
  projectSaved: "Project Saved successfully !"
};

export default function getDict(lang: string): Dict {
  if (lang === "de") return dictDE;
  if (lang === "en") return dictEN;
  return dictEN; // default dictionary
}
