// Timing Constants
export const TIMING = {
  LOADING_TIMEOUT: 4000,
  LIMIT_MESSAGE_DURATION: 3000,
  POPOVER_CLOSE_DELAY: 200,
  PROGRESS_INTERVAL: 150,
  COMPLETE_SCREEN_DELAY: 800,
  VIEWPORT_TRANSITION_DURATION: 0.1, // seconds
} as const;

// Node/Access Point Visual Constants
export const NODE = {
  SIZE: 20,
  INNER_SIZE: 12,
  CENTER_SIZE: 6,
  MOBILE_SIZE: 44, // Minimum touch target size (WCAG recommendation)
  MOBILE_PADDING: 12,
  BORDER_WIDTH: 1,
  SHADOW_OFFSET: 4,
} as const;

// Touch and Drag Constants
export const TOUCH = {
  PREVIEW_OFFSET_X: -20,
  PREVIEW_OFFSET_Y: -40,
  DRAG_OFFSET_X: 20,
  DRAG_OFFSET_Y: 40,
} as const;

// Spacing Constants
export const SPACING = {
  GAP_SMALL: 8,
  GAP_MEDIUM: 10,
  GAP_LARGE: 12,
  PADDING_SMALL: 8,
  PADDING_MEDIUM: 12,
  PADDING_LARGE: 16,
  MARGIN_SMALL: 4,
  MARGIN_MEDIUM: 12,
  MARGIN_LARGE: 24,
} as const;

// Border Radius Constants
export const BORDER_RADIUS = {
  SMALL: 4,
  MEDIUM: 6,
  LARGE: 8,
  CIRCLE: '50%',
} as const;

// Z-Index Layers
export const Z_INDEX = {
  BASE: 0,
  ACCESS_POINT: 50,
  CONTROLS: 1000,
  MODAL: 2000,
  TOOLTIP: 3000,
} as const;

// Typography
export const FONT_SIZE = {
  TINY: 10,
  SMALL: 12,
  MEDIUM: 13,
  REGULAR: 14,
  LARGE: 16,
  XLARGE: 72,
} as const;

// Colors (Hex values)
export const COLORS = {
  ONLINE: '#10b981',
  OFFLINE: '#ef4444',
  PRIMARY: '#006BB4',
  DANGER: '#BD271E',
  BORDER: '#e1e5e9',
  BORDER_DASHED: '#D3DAE6',
  BACKGROUND_LIGHT: '#F5F7FA',
  BACKGROUND_GRAY: '#f8f9fa',
  TEXT_SUBDUED: '#343741',
  WHITE: 'white',
} as const;

// Opacity Values
export const OPACITY = {
  DISABLED: 0.5,
  PREVIEW: 0.8,
  CROSSHAIR: 0.8,
  FULL: 1,
} as const;

// Progress Values
export const PROGRESS = {
  MIN: 0,
  MAX: 100,
  RANDOM_MIN: 2,
  RANDOM_MAX: 8,
} as const;

// Position Values (pixels)
export const POSITION = {
  CONTROL_TOP: 12,
  CONTROL_RIGHT: 12,
  CONTROL_LEFT: 12,
  NODE_CENTER_TOP: 7,
  NODE_CENTER_LEFT: 7,
  NODE_INNER_TOP: 4,
  NODE_INNER_LEFT: 4,
  NODE_CROSSHAIR_TOP: 9,
  NODE_CROSSHAIR_LEFT: 9,
  CROSSHAIR_HORIZONTAL_TOP: 9,
  CROSSHAIR_HORIZONTAL_LEFT: 0,
  CROSSHAIR_VERTICAL_TOP: 0,
  CROSSHAIR_VERTICAL_LEFT: 9,
  TOUCH_LABEL_TOP: 28,
} as const;

// Dimensions (pixels)
export const DIMENSIONS = {
  MIN_WIDTH: 45,
  MEDIUM_WIDTH: 60,
  TOUCH_PREVIEW_SIZE: 24,
  CROSSHAIR_LINE_HEIGHT: 2,
  CROSSHAIR_LINE_WIDTH: 2,
} as const;

// Shadow Definitions
export const SHADOWS = {
  LIGHT: '0 1px 3px rgba(0,0,0,0.3)',
  MEDIUM: '0 2px 8px rgba(0,0,0,0.15)',
  HEAVY: '0 4px 12px rgba(0,0,0,0.4), 0 2px 4px rgba(0,0,0,0.2)',
} as const;
