// import Image from "next/image";

import { DeviceType } from "@/app/types/Device";


export interface IconProps {
  name: "dashboard" | "networks" | "devices" | "antennas" | "internet" | "logs" | "support" | "menu" | "close" | "back" | "edit" | "delete" | DeviceType;
  size?: string;
  style?: "outline" | "filled";
  color?: string;
}

export default function Icon(props: IconProps) {
  let size = "1.6rem";
  if (props.size) size = props.size;

  let style = "outline";
  if (props.style) style = props.style;

  let color = "var(--text)";
  if (props.color) color = props.color;

  return (
    <div style={{
      maskImage: `url(/icons/${props.name}-${style}.svg)`,
      WebkitMaskImage: `url(/icons/${props.name}-${style}.svg)`,
      backgroundColor: color,
      maskPosition: "center",
      WebkitMaskPosition: "center",
      maskRepeat: "no-repeat",
      WebkitMaskRepeat: "no-repeat",
      maskSize: "contain",
      WebkitMaskSize: "contain",
      width: size,
      height: size,
    }}>

    </div>
    // <Image
    //   src={`ionicons/src/svg/${props.name}${ioniconsSuffix}.svg`}
    //   alt={props.name}
    //   width={32}
    //   height={22}
    // />
  )
}
