"use client"

import React from 'react';
import Image from 'next/image';
import { EuiTitle, EuiText, EuiLoadingSpinner } from '@elastic/eui';
import branding from '@/lib/branding';
import styles from './SplashScreen.module.css';

interface SplashScreenProps {
  /** Whether to show the splash screen */
  show: boolean;
  /** Whether the splash screen should fade out */
  fadeOut?: boolean;
  /** Title text to display */
  title?: string;
  /** Subtitle text to display */
  subtitle?: string;
  /** Whether to show the loading spinner */
  showSpinner?: boolean;
}

/**
 * SplashScreen Component
 */
export function SplashScreen({
  show,
  fadeOut = false,
  title,
  subtitle = '',
  showSpinner = true,
}: SplashScreenProps) {
  if (!show) return null;

  return (
    <div className={`${styles.splashScreen} ${fadeOut ? styles.fadeOut : ''}`}>
      <div className={styles.splashLogo}>
        <Image
          src="/logo.svg"
          alt="Logo"
          width={120}
          height={120}
          priority
        />
      </div>
      <div className={styles.splashText}>
        <EuiTitle size="l">
          <h1>{title || branding.productName}</h1>
        </EuiTitle>
        {subtitle && (
          <EuiText size="m" color="subdued" textAlign="center">
            <p>{subtitle}</p>
          </EuiText>
        )}
      </div>
      {showSpinner && (
        <div className={styles.splashSpinner}>
          <EuiLoadingSpinner size="xl" />
        </div>
      )}
    </div>
  );
}
