"use client"

import React from 'react';
import { SplashScreen } from '@/shared/components';
import { useAuthContext } from '@/features/auth';

/**
 * LogoutSplashProvider Component
 *
 * Wraps the application and shows a splash screen during logout.
 * Must be used within the auth context.
 */
export function LogoutSplashProvider({ children }: { children: React.ReactNode }) {
  const { showLogoutSplash, logoutSplashFadeOut } = useAuthContext();

  return (
    <>
      {children}
      <SplashScreen
        show={showLogoutSplash}
        fadeOut={logoutSplashFadeOut}
        title="Goodbye!"
        subtitle="Logging you out..."
        showSpinner={true}
      />
    </>
  );
}
