"use client"

import { EuiProvider } from "@elastic/eui";
import { ToastProvider } from "@/app/components/ToastProvider";
import {LoaderProvider, LoginSplashProvider, LogoutSplashProvider} from "@/shared/providers";
import { AuthProvider } from "@/features/auth";
import { LazyMotion, domAnimation } from "framer-motion";

export function Providers({ children }: { children: React.ReactNode }) {
  return (
    <LazyMotion features={domAnimation} strict>
      <LoaderProvider>
        <EuiProvider colorMode="light">
          <ToastProvider>
            <AuthProvider>
              <LoginSplashProvider>
                <LogoutSplashProvider>
                  {children}
                </LogoutSplashProvider>
              </LoginSplashProvider>
            </AuthProvider>
          </ToastProvider>
        </EuiProvider>
      </LoaderProvider>
    </LazyMotion>
  );
}
